/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.core.ServiceOperator;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataOperateService;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.pojo.ClusterInfo;
import com.alibaba.nacos.naming.pojo.ServiceDetailInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ServiceOperatorV2Impl
implements ServiceOperator {
    private final NamingMetadataOperateService metadataOperateService;
    private final NamingMetadataManager metadataManager;
    private final ServiceStorage serviceStorage;

    public ServiceOperatorV2Impl(NamingMetadataOperateService metadataOperateService, NamingMetadataManager metadataManager, ServiceStorage serviceStorage) {
        this.metadataOperateService = metadataOperateService;
        this.metadataManager = metadataManager;
        this.serviceStorage = serviceStorage;
    }

    @Override
    public void create(String namespaceId, String serviceName, ServiceMetadata metadata) throws NacosException {
        Service service = this.getServiceFromGroupedServiceName(namespaceId, serviceName, metadata.isEphemeral());
        this.create(service, metadata);
    }

    public void create(Service service, ServiceMetadata metadata) throws NacosException {
        if (ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(400, String.format("specified service %s already exists!", service.getGroupedServiceName()));
        }
        this.metadataOperateService.updateServiceMetadata(service, metadata);
    }

    @Override
    public void update(Service service, ServiceMetadata metadata) throws NacosException {
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(400, String.format("service %s not found!", service.getGroupedServiceName()));
        }
        this.metadataOperateService.updateServiceMetadata(service, metadata);
    }

    @Override
    public void delete(String namespaceId, String serviceName) throws NacosException {
        Service service = this.getServiceFromGroupedServiceName(namespaceId, serviceName, true);
        this.delete(service);
    }

    public void delete(Service service) throws NacosException {
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(400, String.format("service %s not found!", service.getGroupedServiceName()));
        }
        if (!this.serviceStorage.getPushData(service).getHosts().isEmpty()) {
            throw new NacosException(400, "Service " + service.getGroupedServiceName() + " is not empty, can't be delete. Please unregister instance first");
        }
        this.metadataOperateService.deleteServiceMetadata(service);
    }

    @Override
    public ObjectNode queryService(String namespaceId, String serviceName) throws NacosException {
        Service service = this.getServiceFromGroupedServiceName(namespaceId, serviceName, true);
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(400, "service not found, namespace: " + namespaceId + ", serviceName: " + serviceName);
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ServiceMetadata serviceMetadata = this.metadataManager.getServiceMetadata(service).orElse(new ServiceMetadata());
        this.setServiceMetadata(result, serviceMetadata, service);
        ArrayNode clusters = JacksonUtils.createEmptyArrayNode();
        for (String each : this.serviceStorage.getClusters(service)) {
            ClusterMetadata clusterMetadata = serviceMetadata.getClusters().containsKey(each) ? serviceMetadata.getClusters().get(each) : new ClusterMetadata();
            clusters.add((JsonNode)this.newClusterNode(each, clusterMetadata));
        }
        result.set("clusters", (JsonNode)clusters);
        return result;
    }

    public ServiceDetailInfo queryService(Service service) throws NacosException {
        if (!ServiceManager.getInstance().containSingleton(service)) {
            throw new NacosException(400, "service not found, namespace: " + service.getNamespace() + ", serviceName: " + service.getGroupedServiceName());
        }
        Service singleton = ServiceManager.getInstance().getSingleton(service);
        ServiceDetailInfo result = new ServiceDetailInfo();
        ServiceMetadata serviceMetadata = this.metadataManager.getServiceMetadata(singleton).orElse(new ServiceMetadata());
        this.setServiceMetadata(result, serviceMetadata, singleton);
        HashMap<String, ClusterInfo> clusters = new HashMap<String, ClusterInfo>(2);
        for (String each : this.serviceStorage.getClusters(singleton)) {
            ClusterMetadata clusterMetadata = serviceMetadata.getClusters().containsKey(each) ? serviceMetadata.getClusters().get(each) : new ClusterMetadata();
            clusters.put(each, this.newClusterNodeV2(each, clusterMetadata));
        }
        result.setClusterMap(clusters);
        result.setEphemeral(singleton.isEphemeral());
        return result;
    }

    private void setServiceMetadata(ObjectNode serviceDetail, ServiceMetadata serviceMetadata, Service service) {
        serviceDetail.put("namespaceId", service.getNamespace());
        serviceDetail.put("groupName", service.getGroup());
        serviceDetail.put("name", service.getName());
        serviceDetail.put("protectThreshold", serviceMetadata.getProtectThreshold());
        serviceDetail.replace("metadata", JacksonUtils.transferToJsonNode(serviceMetadata.getExtendData()));
        serviceDetail.replace("selector", JacksonUtils.transferToJsonNode((Object)serviceMetadata.getSelector()));
    }

    private void setServiceMetadata(ServiceDetailInfo serviceDetail, ServiceMetadata serviceMetadata, Service service) {
        serviceDetail.setNamespace(service.getNamespace());
        serviceDetail.setGroupName(service.getGroup());
        serviceDetail.setServiceName(service.getName());
        serviceDetail.setProtectThreshold(serviceMetadata.getProtectThreshold());
        serviceDetail.setMetadata(serviceMetadata.getExtendData());
        serviceDetail.setSelector(serviceMetadata.getSelector());
    }

    private ObjectNode newClusterNode(String clusterName, ClusterMetadata clusterMetadata) {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("name", clusterName);
        result.replace("healthChecker", JacksonUtils.transferToJsonNode((Object)clusterMetadata.getHealthChecker()));
        result.replace("metadata", JacksonUtils.transferToJsonNode(clusterMetadata.getExtendData()));
        return result;
    }

    private ClusterInfo newClusterNodeV2(String clusterName, ClusterMetadata clusterMetadata) {
        ClusterInfo result = new ClusterInfo();
        result.setClusterName(clusterName);
        result.setHealthChecker(clusterMetadata.getHealthChecker());
        result.setMetadata(clusterMetadata.getExtendData());
        return result;
    }

    @Override
    public Collection<String> listService(String namespaceId, String groupName, String selector) throws NacosException {
        Set<Service> services = ServiceManager.getInstance().getSingletons(namespaceId);
        if (services.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.selectServiceWithGroupName(services, groupName);
    }

    private Collection<String> selectServiceWithGroupName(Collection<Service> serviceSet, String groupName) {
        HashSet<String> result = new HashSet<String>(serviceSet.size());
        for (Service each : serviceSet) {
            if (!Objects.equals(groupName, each.getGroup())) continue;
            result.add(each.getGroupedServiceName());
        }
        return result;
    }

    private Service getServiceFromGroupedServiceName(String namespaceId, String groupedServiceName, boolean ephemeral) {
        String groupName = NamingUtils.getGroupName((String)groupedServiceName);
        String serviceName = NamingUtils.getServiceName((String)groupedServiceName);
        return Service.newService(namespaceId, groupName, serviceName, ephemeral);
    }

    @Override
    public Collection<String> listAllNamespace() {
        return ServiceManager.getInstance().getAllNamespaces();
    }

    @Override
    public Collection<String> searchServiceName(String namespaceId, String expr, boolean responsibleOnly) throws NacosException {
        String regex = ".*" + expr + ".*";
        HashSet<String> result = new HashSet<String>();
        for (Service each : ServiceManager.getInstance().getSingletons(namespaceId)) {
            String groupedServiceName = each.getGroupedServiceName();
            if (!groupedServiceName.matches(regex)) continue;
            result.add(groupedServiceName);
        }
        return result;
    }
}

