/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.event.metadata.MetadataEvent;
import com.alibaba.nacos.naming.core.v2.index.ClientServiceIndexesManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteAction;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV1Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.concurrent.TimeUnit;

public class DoubleWriteServiceRemovalToV2Task
extends AbstractExecuteTask {
    private static final int MAX_WAIT_TIMES = 5;
    private final Service service;

    public DoubleWriteServiceRemovalToV2Task(Service service) {
        this.service = service;
    }

    public void run() {
        try {
            InstanceOperatorClientImpl instanceOperator = (InstanceOperatorClientImpl)ApplicationUtils.getBean(InstanceOperatorClientImpl.class);
            ClientServiceIndexesManager clientServiceIndexesManager = (ClientServiceIndexesManager)((Object)ApplicationUtils.getBean(ClientServiceIndexesManager.class));
            ServiceStorage serviceStorage = (ServiceStorage)ApplicationUtils.getBean(ServiceStorage.class);
            ServiceInfo serviceInfo = serviceStorage.getPushData(this.service);
            for (Instance instance : serviceInfo.getHosts()) {
                instanceOperator.removeInstance(this.service.getNamespace(), this.service.getName(), instance);
            }
            for (int count = 0; !clientServiceIndexesManager.getAllClientsRegisteredService(this.service).isEmpty() && count < 5; ++count) {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            clientServiceIndexesManager.removePublisherIndexesByEmptyService(this.service);
            ServiceManager.getInstance().removeSingleton(this.service);
            serviceStorage.removeData(this.service);
            NotifyCenter.publishEvent((Event)new MetadataEvent.ServiceMetadataEvent(this.service, true));
        }
        catch (Exception e) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("Double write removal of {} from 1 to 2 failed", (Object)this.service, (Object)e);
            }
            ServiceChangeV1Task retryTask = new ServiceChangeV1Task(this.service.getNamespace(), this.service.getGroupedServiceName(), this.service.isEphemeral(), DoubleWriteContent.BOTH, DoubleWriteAction.REMOVE);
            retryTask.setTaskInterval(3000L);
            String taskKey = ServiceChangeV1Task.getKey(this.service.getNamespace(), this.service.getGroupedServiceName(), this.service.isEphemeral());
            ((DoubleWriteDelayTaskEngine)((Object)ApplicationUtils.getBean(DoubleWriteDelayTaskEngine.class))).addTask(taskKey, retryTask);
        }
    }
}

