/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.extend;

import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckExtendProvider
implements BeanFactoryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckExtendProvider.class);
    private final Collection<HealthCheckProcessor> processors = NacosServiceLoader.load(HealthCheckProcessor.class);
    private final Collection<AbstractHealthChecker> checkers = NacosServiceLoader.load(AbstractHealthChecker.class);
    private SingletonBeanRegistry registry;

    public void init() {
        this.loadExtend();
    }

    private void loadExtend() {
        Object type2;
        Iterator<HealthCheckProcessor> processorIt = this.processors.iterator();
        Iterator<AbstractHealthChecker> healthCheckerIt = this.checkers.iterator();
        HashSet<String> origin = new HashSet<String>();
        for (Object type2 : HealthCheckType.values()) {
            origin.add(type2.name());
        }
        HashSet<HealthCheckType> processorType = new HashSet<HealthCheckType>(origin);
        HashSet<HealthCheckType> healthCheckerType = new HashSet<HealthCheckType>(origin);
        while (processorIt.hasNext()) {
            HealthCheckProcessor processor = processorIt.next();
            type2 = processor.getType();
            if (processorType.contains(type2)) {
                throw new RuntimeException("More than one processor of the same type was found : [type=\"" + (String)type2 + "\"]");
            }
            processorType.add((HealthCheckType)type2);
            this.registry.registerSingleton(this.lowerFirstChar(processor.getClass().getSimpleName()), (Object)processor);
        }
        while (healthCheckerIt.hasNext()) {
            AbstractHealthChecker checker = healthCheckerIt.next();
            type2 = checker.getType();
            if (healthCheckerType.contains(type2)) {
                throw new RuntimeException("More than one healthChecker of the same type was found : [type=\"" + (String)type2 + "\"]");
            }
            healthCheckerType.add((HealthCheckType)type2);
            HealthCheckType.registerHealthChecker((String)checker.getType(), checker.getClass());
        }
        if (!processorType.equals(healthCheckerType)) {
            throw new RuntimeException("An unmatched processor and healthChecker are detected in the extension package.");
        }
        if (processorType.size() > origin.size()) {
            processorType.removeAll(origin);
            LOGGER.debug("init health plugin : types=" + processorType);
        }
    }

    private String lowerFirstChar(String simpleName) {
        if (StringUtils.isBlank((CharSequence)simpleName)) {
            throw new IllegalArgumentException("can't find extend processor class name");
        }
        return String.valueOf(simpleName.charAt(0)).toLowerCase() + simpleName.substring(1);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof SingletonBeanRegistry) {
            this.registry = (SingletonBeanRegistry)beanFactory;
        }
    }
}

