/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.heartbeat;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.core.v2.event.service.ServiceEvent;
import com.alibaba.nacos.naming.core.v2.pojo.HealthCheckInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.healthcheck.heartbeat.BeatProcessor;
import com.alibaba.nacos.naming.misc.Loggers;

public class ClientBeatProcessorV2
implements BeatProcessor {
    private final String namespace;
    private final RsInfo rsInfo;
    private final IpPortBasedClient client;

    public ClientBeatProcessorV2(String namespace, RsInfo rsInfo, IpPortBasedClient ipPortBasedClient) {
        this.namespace = namespace;
        this.rsInfo = rsInfo;
        this.client = ipPortBasedClient;
    }

    @Override
    public void run() {
        if (Loggers.EVT_LOG.isDebugEnabled()) {
            Loggers.EVT_LOG.debug("[CLIENT-BEAT] processing beat: {}", (Object)this.rsInfo.toString());
        }
        String ip = this.rsInfo.getIp();
        int port = this.rsInfo.getPort();
        String serviceName = NamingUtils.getServiceName((String)this.rsInfo.getServiceName());
        String groupName = NamingUtils.getGroupName((String)this.rsInfo.getServiceName());
        Service service = Service.newService(this.namespace, groupName, serviceName, this.rsInfo.isEphemeral());
        HealthCheckInstancePublishInfo instance = (HealthCheckInstancePublishInfo)this.client.getInstancePublishInfo(service);
        if (instance.getIp().equals(ip) && instance.getPort() == port) {
            if (Loggers.EVT_LOG.isDebugEnabled()) {
                Loggers.EVT_LOG.debug("[CLIENT-BEAT] refresh beat: {}", (Object)this.rsInfo);
            }
            instance.setLastHeartBeatTime(System.currentTimeMillis());
            if (!instance.isHealthy()) {
                instance.setHealthy(true);
                Loggers.EVT_LOG.info("service: {} {POS} {IP-ENABLED} valid: {}:{}@{}, region: {}, msg: client beat ok", new Object[]{this.rsInfo.getServiceName(), ip, port, this.rsInfo.getCluster(), "unknown"});
                NotifyCenter.publishEvent((Event)new ServiceEvent.ServiceChangedEvent(service));
                NotifyCenter.publishEvent((Event)new ClientEvent.ClientChangedEvent(this.client));
            }
        }
    }
}

