/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.Message;
import com.alibaba.nacos.naming.misc.NamingProxy;
import com.alibaba.nacos.naming.misc.NetUtils;
import com.alibaba.nacos.naming.misc.Synchronizer;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.HashMap;

public class ServiceStatusSynchronizer
implements Synchronizer {
    @Override
    public void send(final String serverIp, Message msg) {
        if (serverIp == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(10);
        params.put("statuses", msg.getData());
        params.put("clientIP", NetUtils.localServer());
        String url = "http://" + serverIp + ":" + EnvUtil.getPort() + EnvUtil.getContextPath() + "/v1/ns" + "/service/status";
        if (InternetAddressUtil.containsPort((String)serverIp)) {
            url = "http://" + serverIp + EnvUtil.getContextPath() + "/v1/ns" + "/service/status";
        }
        try {
            HttpClient.asyncHttpPostLarge(url, null, JacksonUtils.toJson(params), new Callback<String>(){

                public void onReceive(RestResult<String> result) {
                    if (!result.ok()) {
                        Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] failed to request serviceStatus, remote server: {}", (Object)serverIp);
                    }
                }

                public void onError(Throwable throwable) {
                    Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] failed to request serviceStatus, remote server: " + serverIp, throwable);
                }

                public void onCancel() {
                }
            });
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] failed to request serviceStatus, remote server: " + serverIp, (Throwable)e);
        }
    }

    @Override
    public Message get(String serverIp, String key) {
        String result;
        if (serverIp == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        String keyStr = "key";
        params.put(keyStr, key);
        try {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("[STATUS-SYNCHRONIZE] sync service status from: {}, service: {}", (Object)serverIp, (Object)key);
            }
            result = NamingProxy.reqApi(EnvUtil.getContextPath() + "/v1/ns" + "/instance/statuses", params, serverIp);
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] Failed to get service status from " + serverIp, (Throwable)e);
            return null;
        }
        if (result == null || result.equals("")) {
            return null;
        }
        Message msg = new Message();
        msg.setData(result);
        return msg;
    }
}

