/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.prometheus.controller;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(name={"nacos.prometheus.metrics.enabled"}, havingValue="true")
public class PrometheusController {
    @Autowired
    private InstanceOperatorClientImpl instanceServiceV2;
    private final ServiceManager serviceManager = ServiceManager.getInstance();

    @GetMapping(value={"/prometheus"}, produces={"application/json; charset=UTF-8"})
    public ResponseEntity metric() throws NacosException {
        ArrayNode arrayNode = JacksonUtils.createEmptyArrayNode();
        HashSet<Instance> targetSet = new HashSet<Instance>();
        Set allNamespaces = this.serviceManager.getAllNamespaces();
        for (String namespace : allNamespaces) {
            Set singletons = this.serviceManager.getSingletons(namespace);
            for (Service service : singletons) {
                List instances = this.instanceServiceV2.listAllInstances(namespace, service.getName());
                for (Instance instance : instances) {
                    targetSet.add(instance);
                }
            }
        }
        Map<String, List<Instance>> groupingInsMap = targetSet.stream().collect(Collectors.groupingBy(Instance::getClusterName));
        groupingInsMap.forEach((key, value) -> {
            ObjectNode jsonNode = JacksonUtils.createEmptyJsonNode();
            ArrayNode targetsNode = JacksonUtils.createEmptyArrayNode();
            ObjectNode labelNode = JacksonUtils.createEmptyJsonNode();
            value.forEach(e -> targetsNode.add(e.getIp() + ":" + e.getPort()));
            labelNode.put("__meta_clusterName", key);
            jsonNode.replace("targets", (JsonNode)targetsNode);
            jsonNode.replace("labels", (JsonNode)labelNode);
            arrayNode.add((JsonNode)jsonNode);
        });
        return ResponseEntity.ok().body((Object)arrayNode.toString());
    }
}

