/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest.configuration;

import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import springfox.documentation.annotations.Incubating;
import springfox.documentation.builders.AlternateTypeBuilder;
import springfox.documentation.builders.AlternateTypePropertyBuilder;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.schema.AlternateTypeRules;

@Configuration
@ComponentScan(basePackages={"springfox.documentation.spring.data.rest"})
@Incubating(value="2.5.0")
public class SpringDataRestConfiguration {
    @Bean
    public AlternateTypeRuleConvention pageableConvention(final TypeResolver resolver, final RepositoryRestConfiguration restConfiguration) {
        return new AlternateTypeRuleConvention(){

            public int getOrder() {
                return Integer.MIN_VALUE;
            }

            public List<AlternateTypeRule> rules() {
                return Collections.singletonList(AlternateTypeRules.newRule((Type)resolver.resolve(Pageable.class, new Type[0]), (Type)resolver.resolve(SpringDataRestConfiguration.this.pageableMixin(restConfiguration), new Type[0])));
            }
        };
    }

    private Type pageableMixin(RepositoryRestConfiguration restConfiguration) {
        return new AlternateTypeBuilder().fullyQualifiedClassName(String.format("%s.generated.%s", Pageable.class.getPackage().getName(), Pageable.class.getSimpleName())).withProperties(Stream.of(this.property(Integer.class, restConfiguration.getPageParamName()), this.property(Integer.class, restConfiguration.getLimitParamName()), this.property(String.class, restConfiguration.getSortParamName())).collect(Collectors.toList())).build();
    }

    private AlternateTypePropertyBuilder property(Class<?> type, String name) {
        return new AlternateTypePropertyBuilder().withName(name).withType(type).withCanRead(true).withCanWrite(true);
    }
}

