/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.CreateWorkflowInstanceCommandStep1;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.response.WorkflowInstanceEvent;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.client.impl.ZeebeObjectMapper;
import io.zeebe.client.impl.command.ArgumentUtil;
import io.zeebe.client.impl.response.CreateWorkflowInstanceResponseImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CreateWorkflowInstanceCommandImpl
implements CreateWorkflowInstanceCommandStep1,
CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep2,
CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 {
    private final ZeebeObjectMapper objectMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CreateWorkflowInstanceRequest.Builder builder;
    private Duration requestTimeout;

    public CreateWorkflowInstanceCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeObjectMapper objectMapper, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.objectMapper = objectMapper;
        this.requestTimeout = requestTimeout;
        this.builder = GatewayOuterClass.CreateWorkflowInstanceRequest.newBuilder();
    }

    @Override
    public CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 variables(InputStream variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.objectMapper.validateJson("variables", variables));
    }

    @Override
    public CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 variables(String variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.objectMapper.validateJson("variables", variables));
    }

    @Override
    public CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 variables(Map<String, Object> variables) {
        return this.variables((Object)variables);
    }

    @Override
    public CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 variables(Object variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.objectMapper.toJson(variables));
    }

    @Override
    public CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep2 bpmnProcessId(String id) {
        this.builder.setBpmnProcessId(id);
        return this;
    }

    @Override
    public CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 version(int version) {
        this.builder.setVersion(version);
        return this;
    }

    @Override
    public CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 latestVersion() {
        return this.version(-1);
    }

    @Override
    public CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 workflowKey(long workflowKey) {
        this.builder.setWorkflowKey(workflowKey);
        return this;
    }

    @Override
    public FinalCommandStep<WorkflowInstanceEvent> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<WorkflowInstanceEvent> send() {
        GatewayOuterClass.CreateWorkflowInstanceRequest request = this.builder.build();
        ZeebeClientFutureImpl<WorkflowInstanceEvent, GatewayOuterClass.CreateWorkflowInstanceResponse> future = new ZeebeClientFutureImpl<WorkflowInstanceEvent, GatewayOuterClass.CreateWorkflowInstanceResponse>(CreateWorkflowInstanceResponseImpl::new);
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).createWorkflowInstance(request, future);
        return future;
    }

    private CreateWorkflowInstanceCommandStep1.CreateWorkflowInstanceCommandStep3 setVariables(String jsonDocument) {
        this.builder.setVariables(jsonDocument);
        return this;
    }
}

