/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import com.google.protobuf.ByteString;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.ClientException;
import io.zeebe.client.api.command.DeployWorkflowCommandStep1;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.response.DeploymentEvent;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.client.impl.command.ArgumentUtil;
import io.zeebe.client.impl.command.StreamUtil;
import io.zeebe.client.impl.response.DeploymentEventImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import io.zeebe.model.bpmn.Bpmn;
import io.zeebe.model.bpmn.BpmnModelInstance;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DeployWorkflowCommandImpl
implements DeployWorkflowCommandStep1,
DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 {
    private final GatewayOuterClass.DeployWorkflowRequest.Builder request = GatewayOuterClass.DeployWorkflowRequest.newBuilder();
    private final GatewayGrpc.GatewayStub asyncStub;
    private Duration requestTimeout;

    public DeployWorkflowCommandImpl(GatewayGrpc.GatewayStub asyncStub, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
    }

    @Override
    public DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 addResourceBytes(byte[] resource, String resourceName) {
        this.request.addWorkflows(GatewayOuterClass.WorkflowRequestObject.newBuilder().setType(GatewayOuterClass.WorkflowRequestObject.ResourceType.FILE).setName(resourceName).setDefinition(ByteString.copyFrom((byte[])resource)));
        return this;
    }

    @Override
    public DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 addResourceString(String resource, Charset charset, String resourceName) {
        return this.addResourceBytes(resource.getBytes(charset), resourceName);
    }

    @Override
    public DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 addResourceStringUtf8(String resourceString, String resourceName) {
        return this.addResourceString(resourceString, StandardCharsets.UTF_8, resourceName);
    }

    @Override
    public DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 addResourceStream(InputStream resourceStream, String resourceName) {
        ArgumentUtil.ensureNotNull("resource stream", resourceStream);
        try {
            byte[] bytes = StreamUtil.readInputStream(resourceStream);
            return this.addResourceBytes(bytes, resourceName);
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy bpmn resource from stream. %s", e.getMessage());
            throw new ClientException(exceptionMsg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 addResourceFromClasspath(String classpathResource) {
        ArgumentUtil.ensureNotNull("classpath resource", classpathResource);
        try (InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(classpathResource);){
            if (resourceStream != null) {
                DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 deployWorkflowCommandBuilderStep2 = this.addResourceStream(resourceStream, classpathResource);
                return deployWorkflowCommandBuilderStep2;
            }
            throw new FileNotFoundException(classpathResource);
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy resource from classpath. %s", e.getMessage());
            throw new RuntimeException(exceptionMsg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 addResourceFile(String filename) {
        ArgumentUtil.ensureNotNull("filename", filename);
        try (FileInputStream resourceStream = new FileInputStream(filename);){
            DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 deployWorkflowCommandBuilderStep2 = this.addResourceStream(resourceStream, filename);
            return deployWorkflowCommandBuilderStep2;
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy resource from file. %s", e.getMessage());
            throw new RuntimeException(exceptionMsg, e);
        }
    }

    @Override
    public DeployWorkflowCommandStep1.DeployWorkflowCommandBuilderStep2 addWorkflowModel(BpmnModelInstance workflowDefinition, String resourceName) {
        ArgumentUtil.ensureNotNull("workflow model", workflowDefinition);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)workflowDefinition);
        return this.addResourceBytes(outStream.toByteArray(), resourceName);
    }

    @Override
    public FinalCommandStep<DeploymentEvent> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<DeploymentEvent> send() {
        ZeebeClientFutureImpl<DeploymentEvent, GatewayOuterClass.DeployWorkflowResponse> future = new ZeebeClientFutureImpl<DeploymentEvent, GatewayOuterClass.DeployWorkflowResponse>(DeploymentEventImpl::new);
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).deployWorkflow(this.request.build(), future);
        return future;
    }
}

