/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FailJobCommandStep1;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class FailJobCommandImpl
implements FailJobCommandStep1,
FailJobCommandStep1.FailJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.FailJobRequest.Builder builder;
    private Duration requestTimeout;

    public FailJobCommandImpl(GatewayGrpc.GatewayStub asyncStub, long key, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.builder = GatewayOuterClass.FailJobRequest.newBuilder();
        this.builder.setJobKey(key);
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 retries(int retries) {
        this.builder.setRetries(retries);
        return this;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 errorMessage(String errorMsg) {
        this.builder.setErrorMessage(errorMsg);
        return this;
    }

    @Override
    public FinalCommandStep<Void> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Void> send() {
        GatewayOuterClass.FailJobRequest request = this.builder.build();
        ZeebeClientFutureImpl future = new ZeebeClientFutureImpl();
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).failJob(request, future);
        return future;
    }
}

