/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class JobUpdateRetriesCommandImpl
implements UpdateRetriesJobCommandStep1,
UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.UpdateJobRetriesRequest.Builder builder;
    private Duration requestTimeout;

    public JobUpdateRetriesCommandImpl(GatewayGrpc.GatewayStub asyncStub, long jobKey, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.builder = GatewayOuterClass.UpdateJobRetriesRequest.newBuilder();
        this.builder.setJobKey(jobKey);
    }

    @Override
    public UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 retries(int retries) {
        this.builder.setRetries(retries);
        return this;
    }

    @Override
    public FinalCommandStep<Void> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Void> send() {
        GatewayOuterClass.UpdateJobRetriesRequest request = this.builder.build();
        ZeebeClientFutureImpl future = new ZeebeClientFutureImpl();
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).updateJobRetries(request, future);
        return future;
    }
}

