/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.worker;

import io.zeebe.client.api.response.ActivatedJob;
import io.zeebe.client.api.worker.JobWorker;
import io.zeebe.client.impl.Loggers;
import io.zeebe.client.impl.worker.JobPoller;
import io.zeebe.client.impl.worker.JobRunnableFactory;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class JobWorkerImpl
implements JobWorker,
Closeable {
    private static final Logger LOG = Loggers.JOB_WORKER_LOGGER;
    private final int maxJobsActive;
    private final int activationThreshold;
    private final AtomicInteger remainingJobs;
    private final ExecutorService executor;
    private final JobRunnableFactory jobRunnableFactory;
    private final AtomicBoolean acquiringJobs = new AtomicBoolean(true);
    private final AtomicReference<JobPoller> jobPoller;

    public JobWorkerImpl(int maxJobsActive, ScheduledExecutorService executor, Duration pollInterval, JobRunnableFactory jobRunnableFactory, JobPoller jobPoller) {
        this.maxJobsActive = maxJobsActive;
        this.activationThreshold = Math.round((float)maxJobsActive * 0.3f);
        this.remainingJobs = new AtomicInteger(0);
        this.executor = executor;
        this.jobRunnableFactory = jobRunnableFactory;
        this.jobPoller = new AtomicReference<JobPoller>(jobPoller);
        executor.scheduleWithFixedDelay(this::tryActivateJobs, 0L, pollInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isOpen() {
        return this.acquiringJobs.get();
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen() && this.jobPoller.get() != null && this.remainingJobs.get() <= 0;
    }

    @Override
    public void close() {
        this.acquiringJobs.set(false);
    }

    private void tryActivateJobs() {
        int remainingJobs = this.remainingJobs.get();
        if (this.shouldActivateJobs(remainingJobs)) {
            this.activateJobs();
        }
    }

    private void activateJobs() {
        JobPoller jobPoller = this.jobPoller.getAndSet(null);
        if (jobPoller != null) {
            int currentRemainingJobs = this.remainingJobs.get();
            if (this.shouldActivateJobs(currentRemainingJobs)) {
                int maxActivatedJobs = this.maxJobsActive - currentRemainingJobs;
                try {
                    jobPoller.poll(maxActivatedJobs, this::submitJob, activatedJobs -> {
                        this.remainingJobs.addAndGet((int)activatedJobs);
                        this.jobPoller.set(jobPoller);
                    });
                }
                catch (Exception e) {
                    LOG.warn("Failed to activate jobs", (Throwable)e);
                    this.jobPoller.set(jobPoller);
                }
            } else {
                this.jobPoller.set(jobPoller);
            }
        }
    }

    private boolean shouldActivateJobs(int remainingJobs) {
        return this.acquiringJobs.get() && remainingJobs <= this.activationThreshold;
    }

    private void submitJob(ActivatedJob job) {
        this.executor.execute(this.jobRunnableFactory.create(job, this::jobHandlerFinished));
    }

    private void jobHandlerFinished() {
        int remainingJobs = this.remainingJobs.decrementAndGet();
        if (this.shouldActivateJobs(remainingJobs)) {
            this.activateJobs();
        }
    }
}

