/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.internal.DefaultSpanCodec;
import com.github.kristofa.brave.internal.InternalSpan;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import zipkin.reporter.Reporter;

abstract class Recorder
implements AnnotationSubmitter.Clock {
    Recorder() {
    }

    abstract void name(Span var1, String var2);

    abstract void start(Span var1, long var2);

    abstract Long timestamp(Span var1);

    abstract void annotate(Span var1, long var2, String var4);

    abstract void address(Span var1, String var2, Endpoint var3);

    abstract void tag(Span var1, String var2, String var3);

    abstract void finish(Span var1, long var2);

    abstract void flush(Span var1);

    static abstract class Default
    extends Recorder {
        Default() {
        }

        abstract Endpoint localEndpoint();

        abstract AnnotationSubmitter.Clock clock();

        abstract Reporter<zipkin.Span> reporter();

        @Override
        public long currentTimeMicroseconds() {
            return this.clock().currentTimeMicroseconds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void name(Span span, String name) {
            Span span2 = span;
            synchronized (span2) {
                span.setName(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void start(Span span, long timestamp) {
            Span span2 = span;
            synchronized (span2) {
                span.setTimestamp(timestamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Long timestamp(Span span) {
            Span span2 = span;
            synchronized (span2) {
                return span.getTimestamp();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void annotate(Span span, long timestamp, String value) {
            Annotation annotation = Annotation.create(timestamp, value, this.localEndpoint());
            Span span2 = span;
            synchronized (span2) {
                span.addToAnnotations(annotation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void address(Span span, String key, Endpoint endpoint) {
            BinaryAnnotation address = BinaryAnnotation.address(key, endpoint);
            Span span2 = span;
            synchronized (span2) {
                span.addToBinary_annotations(address);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void tag(Span span, String key, String value) {
            BinaryAnnotation ba = BinaryAnnotation.create(key, value, this.localEndpoint());
            Span span2 = span;
            synchronized (span2) {
                span.addToBinary_annotations(ba);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void finish(Span span, long timestamp) {
            Span span2 = span;
            synchronized (span2) {
                Long startTimestamp = span.getTimestamp();
                if (startTimestamp != null) {
                    span.setDuration(Math.max(1L, timestamp - startTimestamp));
                }
            }
            this.flush(span);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void flush(Span span) {
            Span span2 = span;
            synchronized (span2) {
                if (InternalSpan.instance.context((Span)span).shared) {
                    int length = span.getAnnotations().size();
                    for (int i = 0; i < length; ++i) {
                        if (!span.getAnnotations().get((int)i).value.equals("sr")) continue;
                        span.setTimestamp(null);
                        break;
                    }
                }
            }
            this.reporter().report((Object)DefaultSpanCodec.toZipkin(span));
        }
    }
}

