/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.http.HttpRequest;
import brave.http.HttpRequestParser;
import brave.http.HttpResponse;
import brave.http.HttpResponseParser;
import brave.internal.Nullable;

abstract class HttpHandler {
    static final Object NULL_SENTINEL = new Object();
    final HttpRequestParser requestParser;
    final HttpResponseParser responseParser;

    HttpHandler(HttpRequestParser requestParser, HttpResponseParser responseParser) {
        this.requestParser = requestParser;
        this.responseParser = responseParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Span handleStart(HttpRequest request, Span span) {
        if (span.isNoop()) {
            return span;
        }
        span.kind(request.spanKind());
        try {
            this.parseRequest(request, span);
        }
        finally {
            long timestamp = request.startTimestamp();
            if (timestamp == 0L) {
                span.start();
            } else {
                span.start(timestamp);
            }
        }
        return span;
    }

    abstract void parseRequest(HttpRequest var1, Span var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFinish(@Nullable HttpResponse response, @Nullable Throwable error, Span span) {
        if (response == null && error == null) {
            throw new IllegalArgumentException("Either the response or error parameters may be null, but not both");
        }
        if (span.isNoop()) {
            return;
        }
        if (error != null) {
            span.error(error);
            if (response == null) {
                span.finish();
                return;
            }
        }
        try {
            this.responseParser.parse(response, span.context(), span.customizer());
        }
        finally {
            long finishTimestamp = response.finishTimestamp();
            if (finishTimestamp == 0L) {
                span.finish();
            } else {
                span.finish(finishTimestamp);
            }
        }
    }
}

