/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.kafka.clients.KafkaHeaders;
import brave.messaging.ConsumerRequest;
import brave.propagation.Propagation;
import org.apache.kafka.clients.consumer.ConsumerRecord;

final class KafkaConsumerRequest
extends ConsumerRequest {
    static final Propagation.RemoteGetter<KafkaConsumerRequest> GETTER = new Propagation.RemoteGetter<KafkaConsumerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.CONSUMER;
        }

        public String get(KafkaConsumerRequest request, String name) {
            return KafkaHeaders.lastStringHeader(request.delegate.headers(), name);
        }

        public String toString() {
            return "Headers::lastHeader";
        }
    };
    static final Propagation.RemoteSetter<KafkaConsumerRequest> SETTER = new Propagation.RemoteSetter<KafkaConsumerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.CONSUMER;
        }

        public void put(KafkaConsumerRequest request, String name, String value) {
            KafkaHeaders.replaceHeader(request.delegate.headers(), name, value);
        }

        public String toString() {
            return "Headers::replace";
        }
    };
    final ConsumerRecord<?, ?> delegate;

    KafkaConsumerRequest(ConsumerRecord<?, ?> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public Span.Kind spanKind() {
        return Span.Kind.CONSUMER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "receive";
    }

    public String channelKind() {
        return "topic";
    }

    public String channelName() {
        return this.delegate.topic();
    }
}

