/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.prometheus.client.CollectorRegistry;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@RestController
public class MetricsHealthController
implements WebMvcConfigurer {
    final MeterRegistry meterRegistry;
    final HealthEndpoint healthEndpoint;
    final HealthStatusHttpMapper statusMapper;
    final CollectorRegistry collectorRegistry;
    final JsonNodeFactory factory = JsonNodeFactory.instance;

    MetricsHealthController(MeterRegistry meterRegistry, HealthEndpoint healthEndpoint, HealthStatusHttpMapper statusMapper, CollectorRegistry collectorRegistry) {
        this.meterRegistry = meterRegistry;
        this.healthEndpoint = healthEndpoint;
        this.statusMapper = statusMapper;
        this.collectorRegistry = collectorRegistry;
    }

    @GetMapping(value={"/metrics"})
    public ObjectNode fetchMetricsFromMicrometer() {
        ObjectNode metrics = this.factory.objectNode();
        for (Meter meter : this.meterRegistry.getMeters()) {
            String transport;
            String name = meter.getId().getName();
            if (!name.startsWith("zipkin_collector") || (transport = meter.getId().getTag("transport")) == null) continue;
            switch (meter.getId().getType()) {
                case COUNTER: {
                    metrics.put("counter." + name + "." + transport, this.meterRegistry.get(name).counter().count());
                    break;
                }
                case GAUGE: {
                    metrics.put("gauge." + name + "." + transport, this.meterRegistry.get(name).gauge().value());
                }
            }
        }
        return metrics;
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<Map> getHealth() {
        Health health = this.healthEndpoint.health();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", health.getStatus().getCode());
        body.put("zipkin", (String)health.getDetails().get("zipkin"));
        return ResponseEntity.status((int)this.statusMapper.mapStatus(health.getStatus())).body(body);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/prometheus", "/actuator/prometheus");
    }
}

