/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6451021435135161911L;
    protected String className = null;
    protected String description = null;
    protected MBeanAttributeInfo[] attributes = null;
    protected MBeanConstructorInfo[] constructors = null;
    protected MBeanOperationInfo[] operations = null;
    protected MBeanNotificationInfo[] notifications = null;
    private transient String cacheString;
    private transient int cacheHashCode;

    public MBeanInfo(String className, String description, MBeanAttributeInfo[] attributes, MBeanConstructorInfo[] constructors, MBeanOperationInfo[] operations, MBeanNotificationInfo[] notifications) {
        this.className = className;
        this.description = description;
        this.attributes = null == attributes ? new MBeanAttributeInfo[]{} : (MBeanAttributeInfo[])attributes.clone();
        this.constructors = null == constructors ? new MBeanConstructorInfo[]{} : (MBeanConstructorInfo[])constructors.clone();
        this.operations = null == operations ? new MBeanOperationInfo[]{} : (MBeanOperationInfo[])operations.clone();
        this.notifications = null == notifications ? new MBeanNotificationInfo[]{} : (MBeanNotificationInfo[])notifications.clone();
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public MBeanAttributeInfo[] getAttributes() {
        return (MBeanAttributeInfo[])this.attributes.clone();
    }

    public MBeanOperationInfo[] getOperations() {
        return (MBeanOperationInfo[])this.operations.clone();
    }

    public MBeanConstructorInfo[] getConstructors() {
        return (MBeanConstructorInfo[])this.constructors.clone();
    }

    public MBeanNotificationInfo[] getNotifications() {
        return (MBeanNotificationInfo[])this.notifications.clone();
    }

    public boolean equals(Object object) {
        MBeanOperationInfo[] otherOpers;
        MBeanNotificationInfo[] otherNotfs;
        MBeanConstructorInfo[] otherCons;
        MBeanAttributeInfo[] otherAttrs;
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MBeanInfo)) {
            return false;
        }
        MBeanInfo other = (MBeanInfo)object;
        if (!this.getClassName().equals(other.getClassName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        MBeanAttributeInfo[] thisAttrs = this.getAttributes();
        if (thisAttrs.length != (otherAttrs = other.getAttributes()).length) {
            return false;
        }
        for (int i = 0; i < thisAttrs.length; ++i) {
            if (thisAttrs[i].equals(otherAttrs[i])) continue;
            return false;
        }
        MBeanConstructorInfo[] thisCons = this.getConstructors();
        if (thisCons.length != (otherCons = other.getConstructors()).length) {
            return false;
        }
        for (int i = 0; i < thisCons.length; ++i) {
            if (thisCons[i].equals(otherCons[i])) continue;
            return false;
        }
        MBeanNotificationInfo[] thisNotfs = this.getNotifications();
        if (thisNotfs.length != (otherNotfs = other.getNotifications()).length) {
            return false;
        }
        for (int i = 0; i < thisNotfs.length; ++i) {
            if (thisNotfs[i].equals(otherNotfs[i])) continue;
            return false;
        }
        MBeanOperationInfo[] thisOpers = this.getOperations();
        if (thisOpers.length != (otherOpers = other.getOperations()).length) {
            return false;
        }
        for (int i = 0; i < thisOpers.length; ++i) {
            if (thisOpers[i].equals(otherOpers[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cacheHashCode == 0) {
            this.cacheHashCode = this.getClassName().hashCode();
            this.cacheHashCode = this.getDescription().hashCode();
        }
        return this.cacheHashCode;
    }

    public String toString() {
        if (this.cacheString == null) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(this.getClass().getName()).append(":");
            buffer.append(" className=").append(this.getClassName());
            buffer.append(" description=").append(this.getDescription());
            buffer.append(" attributes=").append(Arrays.asList(this.attributes));
            buffer.append(" constructors=").append(Arrays.asList(this.constructors));
            buffer.append(" notifications=").append(Arrays.asList(this.notifications));
            buffer.append(" operations=").append(Arrays.asList(this.operations));
            this.cacheString = buffer.toString();
        }
        return this.cacheString;
    }

    public Object clone() throws CloneNotSupportedException {
        MBeanInfo clone = (MBeanInfo)super.clone();
        clone.className = this.getClassName();
        clone.description = this.getDescription();
        clone.attributes = this.getAttributes();
        clone.constructors = this.getConstructors();
        clone.operations = this.getOperations();
        clone.notifications = this.getNotifications();
        return clone;
    }
}

