/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.interfaces;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;

public class OptimizedObjectInputStream
extends ObjectInputStream {
    private static ConcurrentReaderHashMap classCache;
    private static ConcurrentReaderHashMap objectStreamClassCache;

    public static void useClassCache(boolean flag) {
        if (flag) {
            classCache = new ConcurrentReaderHashMap();
            objectStreamClassCache = new ConcurrentReaderHashMap();
        } else {
            classCache = null;
            objectStreamClassCache = null;
        }
    }

    public static void flushClassCache() {
        classCache.clear();
        objectStreamClassCache.clear();
    }

    private static Class forName(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (classCache != null) {
            WeakReference ref = (WeakReference)classCache.get(className);
            if (ref != null) {
                clazz = (Class<?>)ref.get();
            }
            if (clazz == null) {
                if (ref != null) {
                    classCache.remove(className);
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    clazz = loader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    clazz = Class.forName(className, false, loader);
                }
                classCache.put(className, new WeakReference(clazz));
            }
        } else {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        return clazz;
    }

    public OptimizedObjectInputStream(InputStream is) throws IOException {
        super(is);
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        String className = v.getName();
        return OptimizedObjectInputStream.forName(className);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class[] ifaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class iface;
            String className = interfaces[i];
            ifaceClasses[i] = iface = OptimizedObjectInputStream.forName(className);
        }
        return Proxy.getProxyClass(loader, ifaceClasses);
    }

    static {
        OptimizedObjectInputStream.useClassCache(true);
    }
}

