/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.notification;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.jmx.connector.RemoteMBeanServer;
import org.jboss.jmx.connector.notification.ClientNotificationListener;

public class JMSClientNotificationListener
extends ClientNotificationListener
implements MessageListener {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$jms$Queue;
    static /* synthetic */ Class class$javax$jms$QueueConnectionFactory;

    public JMSClientNotificationListener(ObjectName pSender, NotificationListener pClientListener, Object pHandback, NotificationFilter pFilter, String pQueueJNDIName, String pServerName, RemoteMBeanServer pConnector) throws JMSException, JMException, NamingException {
        super(pSender, pClientListener, pHandback);
        QueueConnection lConnection = this.getQueueConnection(pServerName, pQueueJNDIName);
        QueueSession lSession = lConnection.createQueueSession(false, 1);
        TemporaryQueue lQueue = lSession.createTemporaryQueue();
        this.createListener(pConnector, "org.jboss.jmx.connector.notification.JMSNotificationListener", new Object[]{pQueueJNDIName, lQueue}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = JMSClientNotificationListener.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$jms$Queue == null ? (class$javax$jms$Queue = JMSClientNotificationListener.class$("javax.jms.Queue")) : class$javax$jms$Queue).getName()});
        QueueReceiver lReceiver = lSession.createReceiver(lQueue, null);
        lReceiver.setMessageListener(this);
        this.addNotificationListener(pConnector, pFilter);
    }

    public void onMessage(Message pMessage) {
        try {
            Notification lNotification = (Notification)((ObjectMessage)pMessage).getObject();
            this.mClientListener.handleNotification(lNotification, this.mHandback);
        }
        catch (JMSException je) {
            this.log.error("failed to handle notification", je);
        }
    }

    private QueueConnection getQueueConnection(String pServerName, String pQueueJNDIName) throws NamingException, JMSException {
        InitialContext lJNDIContext = null;
        if (pServerName != null) {
            Hashtable<String, String> lProperties = new Hashtable<String, String>();
            lProperties.put("java.naming.provider.url", pServerName);
            lJNDIContext = new InitialContext(lProperties);
        } else {
            lJNDIContext = new InitialContext();
        }
        Object aRef = lJNDIContext.lookup(pQueueJNDIName);
        QueueConnectionFactory aFactory = (QueueConnectionFactory)PortableRemoteObject.narrow((Object)aRef, (Class)(class$javax$jms$QueueConnectionFactory == null ? (class$javax$jms$QueueConnectionFactory = JMSClientNotificationListener.class$("javax.jms.QueueConnectionFactory")) : class$javax$jms$QueueConnectionFactory));
        QueueConnection lConnection = aFactory.createQueueConnection();
        lConnection.start();
        return lConnection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

