/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.notification;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.management.Notification;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.jmx.connector.notification.JMSNotificationListenerMBean;
import org.jboss.logging.Logger;

public class JMSNotificationListener
implements JMSNotificationListenerMBean {
    private static final Logger log = Logger.getLogger(class$org$jboss$jmx$connector$notification$JMSNotificationListener == null ? (class$org$jboss$jmx$connector$notification$JMSNotificationListener = JMSNotificationListener.class$("org.jboss.jmx.connector.notification.JMSNotificationListener")) : class$org$jboss$jmx$connector$notification$JMSNotificationListener);
    private transient QueueSender mSender;
    private transient QueueSession mSession;
    private String mJNDIName;
    private Queue mQueue;
    static /* synthetic */ Class class$org$jboss$jmx$connector$notification$JMSNotificationListener;
    static /* synthetic */ Class class$javax$jms$QueueConnectionFactory;

    public JMSNotificationListener(String pJNDIName, Queue pQueue) throws JMSException {
        this.mJNDIName = pJNDIName;
        this.mQueue = pQueue;
    }

    public void handleNotification(Notification pNotification, Object pHandback) {
        try {
            if (this.mSender == null) {
                QueueConnection lConnection = this.getQueueConnection(this.mJNDIName);
                this.mSession = lConnection.createQueueSession(false, 1);
                this.mSender = this.mSession.createSender(this.mQueue);
            }
            ObjectMessage lMessage = this.mSession.createObjectMessage(pNotification);
            this.mSender.send(lMessage);
        }
        catch (Exception e) {
            log.error("failed to handle notification", e);
        }
    }

    public boolean equals(Object pTest) {
        if (pTest instanceof JMSNotificationListener) {
            try {
                return this.mQueue.getQueueName().equals(((JMSNotificationListener)pTest).mQueue.getQueueName());
            }
            catch (JMSException je) {
                log.error("equality test failed", je);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.mQueue.hashCode();
    }

    private QueueConnection getQueueConnection(String pJNDIName) throws NamingException, JMSException {
        InitialContext aJNDIContext = new InitialContext();
        Object aRef = aJNDIContext.lookup(pJNDIName);
        QueueConnectionFactory aFactory = (QueueConnectionFactory)PortableRemoteObject.narrow((Object)aRef, (Class)(class$javax$jms$QueueConnectionFactory == null ? (class$javax$jms$QueueConnectionFactory = JMSNotificationListener.class$("javax.jms.QueueConnectionFactory")) : class$javax$jms$QueueConnectionFactory));
        QueueConnection lConnection = aFactory.createQueueConnection();
        lConnection.start();
        return lConnection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

