/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.TransactionRequest;

public class SpyXAResourceManager
implements Serializable {
    static final long serialVersionUID = -6268132972627753772L;
    private static final Logger log = Logger.getLogger(class$org$jboss$mq$SpyXAResourceManager == null ? (class$org$jboss$mq$SpyXAResourceManager = SpyXAResourceManager.class$("org.jboss.mq.SpyXAResourceManager")) : class$org$jboss$mq$SpyXAResourceManager);
    private static boolean trace = log.isTraceEnabled();
    private static final byte TX_OPEN = 0;
    private static final byte TX_ENDED = 1;
    private static final byte TX_PREPARED = 3;
    private static final byte TX_COMMITED = 4;
    private static final byte TX_ROLLEDBACK = 5;
    private Connection connection;
    private Map transactions = new ConcurrentReaderHashMap();
    private long nextInternalXid = Long.MIN_VALUE;
    static /* synthetic */ Class class$org$jboss$mq$SpyXAResourceManager;

    public SpyXAResourceManager(Connection conn) {
        this.connection = conn;
    }

    public void ackMessage(Object xid, SpyMessage msg) throws JMSException {
        TXState state;
        if (xid == null) {
            if (trace) {
                log.trace("No Xid, acking message " + msg.header.jmsMessageID);
            }
            msg.doAcknowledge();
            return;
        }
        if (trace) {
            log.trace("Adding acked message xid=" + xid + " " + msg.header.jmsMessageID);
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            throw new JMSException("Invalid transaction id.");
        }
        AcknowledgementRequest item = msg.getAcknowledgementRequest(true);
        state.ackedMessages.add(item);
    }

    public void addMessage(Object xid, SpyMessage msg) throws JMSException {
        if (xid == null) {
            if (trace) {
                log.trace("No Xid, sending message to server " + msg.header.jmsMessageID);
            }
            this.connection.sendToServer(msg);
            return;
        }
        if (trace) {
            log.trace("Adding message xid=" + xid + ", message=" + msg.header.jmsMessageID);
        }
        TXState state = (TXState)this.transactions.get(xid);
        if (trace) {
            log.trace("TXState=" + state);
        }
        if (state == null) {
            throw new JMSException("Invalid transaction id.");
        }
        state.sentMessages.add(msg);
    }

    public void commit(Object xid, boolean onePhase) throws XAException, JMSException {
        TXState state;
        if (trace) {
            log.trace("Commiting xid=" + xid + ", onePhase=" + onePhase);
        }
        if ((state = (TXState)this.transactions.remove(xid)) == null) {
            throw new XAException(-4);
        }
        if (onePhase) {
            Externalizable[] job;
            TransactionRequest transaction = new TransactionRequest();
            transaction.requestType = 0;
            transaction.xid = null;
            if (state.sentMessages.size() != 0) {
                job = new SpyMessage[state.sentMessages.size()];
                job = state.sentMessages.toArray(job);
                transaction.messages = job;
            }
            if (state.ackedMessages.size() != 0) {
                job = new AcknowledgementRequest[state.ackedMessages.size()];
                job = (AcknowledgementRequest[])state.ackedMessages.toArray(job);
                transaction.acks = job;
            }
            this.connection.send(transaction);
        } else {
            if (state.txState != 3) {
                throw new XAException("The transaction had not been prepared");
            }
            TransactionRequest transaction = new TransactionRequest();
            transaction.xid = xid;
            transaction.requestType = (byte)2;
            this.connection.send(transaction);
        }
        state.txState = (byte)4;
    }

    public void endTx(Object xid, boolean success) throws XAException {
        TXState state;
        if (trace) {
            log.trace("Ending xid=" + xid + ", success=" + success);
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            throw new XAException(-4);
        }
        state.txState = 1;
    }

    public Object joinTx(Xid xid) throws XAException {
        if (trace) {
            log.trace("Joining tx xid=" + xid);
        }
        if (!this.transactions.containsKey(xid)) {
            throw new XAException(-4);
        }
        return xid;
    }

    public int prepare(Object xid) throws XAException, JMSException {
        Externalizable[] job;
        TXState state;
        if (trace) {
            log.trace("Preparing xid=" + xid);
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            throw new XAException(-4);
        }
        TransactionRequest transaction = new TransactionRequest();
        transaction.requestType = 1;
        transaction.xid = xid;
        if (state.sentMessages.size() != 0) {
            job = new SpyMessage[state.sentMessages.size()];
            job = state.sentMessages.toArray(job);
            transaction.messages = job;
        }
        if (state.ackedMessages.size() != 0) {
            job = new AcknowledgementRequest[state.ackedMessages.size()];
            job = (AcknowledgementRequest[])state.ackedMessages.toArray(job);
            transaction.acks = job;
        }
        this.connection.send(transaction);
        state.txState = (byte)3;
        return 0;
    }

    public Object resumeTx(Xid xid) throws XAException {
        if (trace) {
            log.trace("Resuming tx xid=" + xid);
        }
        if (!this.transactions.containsKey(xid)) {
            throw new XAException(-4);
        }
        return xid;
    }

    public void rollback(Object xid) throws XAException, JMSException {
        TXState state;
        if (trace) {
            log.trace("Rolling back xid=" + xid);
        }
        if ((state = (TXState)this.transactions.remove(xid)) == null) {
            throw new XAException(-4);
        }
        if (state.txState != 3) {
            TransactionRequest transaction = new TransactionRequest();
            transaction.requestType = 0;
            transaction.xid = null;
            if (state.ackedMessages.size() != 0) {
                AcknowledgementRequest[] job = new AcknowledgementRequest[state.ackedMessages.size()];
                job = state.ackedMessages.toArray(job);
                transaction.acks = job;
                for (int i = 0; i < transaction.acks.length; ++i) {
                    transaction.acks[i].isAck = false;
                }
            }
            this.connection.send(transaction);
        } else {
            TransactionRequest transaction = new TransactionRequest();
            transaction.xid = xid;
            transaction.requestType = (byte)3;
            this.connection.send(transaction);
        }
        state.txState = (byte)5;
    }

    public synchronized Long getNewXid() {
        return new Long(this.nextInternalXid++);
    }

    public Object startTx() {
        Long newXid = this.getNewXid();
        this.transactions.put(newXid, new TXState());
        if (trace) {
            log.trace("Starting tx with new xid=" + newXid);
        }
        return newXid;
    }

    public Object startTx(Xid xid) throws XAException {
        if (trace) {
            log.trace("Starting tx xid=" + xid);
        }
        if (this.transactions.containsKey(xid)) {
            throw new XAException(-8);
        }
        this.transactions.put(xid, new TXState());
        return xid;
    }

    public Object suspendTx(Xid xid) throws XAException {
        if (trace) {
            log.trace("Suppending tx xid=" + xid);
        }
        if (!this.transactions.containsKey(xid)) {
            throw new XAException(-4);
        }
        return xid;
    }

    public Object convertTx(Long anonXid, Xid xid) throws XAException {
        if (trace) {
            log.trace("Converting tx anonXid=" + anonXid + ", xid=" + xid);
        }
        if (!this.transactions.containsKey(anonXid)) {
            throw new XAException(-4);
        }
        if (this.transactions.containsKey(xid)) {
            throw new XAException(-8);
        }
        TXState s = (TXState)this.transactions.remove(anonXid);
        this.transactions.put(xid, s);
        return xid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TXState {
        byte txState = 0;
        ArrayList sentMessages = new ArrayList();
        ArrayList ackedMessages = new ArrayList();

        TXState() {
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("TxState txState=").append(this.txState);
            buffer.append(" sent=").append(this.sentMessages);
            buffer.append(" acks=").append(this.ackedMessages);
            return buffer.toString();
        }
    }
}

