/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.jboss.mq.il.uil.multiplexor.StreamDemux;
import org.jboss.mq.il.uil.multiplexor.StreamMux;

public class MultiplexorTest {
    StreamMux mux;
    StreamDemux demux;
    public static final int PAY_LOAD_SIZE = 10240;
    public static char[] PAY_LOAD;

    public MultiplexorTest() {
        char[] s = new char[10240];
        int c = 65;
        for (int i = 0; i < 10240; ++i) {
            s[i] = c;
            c = (c = (int)((char)(c + 1))) > 90 ? 65 : c;
        }
        PAY_LOAD = s;
    }

    public void connect() throws IOException {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        this.mux = new StreamMux(pos);
        this.demux = new StreamDemux(pis);
    }

    public void startStream(short id) throws IOException {
        new WriterThread(id).start();
        new ReaderThread(id).start();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Initializing");
        MultiplexorTest tester = new MultiplexorTest();
        System.out.println("Connecting the streams");
        tester.connect();
        System.out.println("Starting stream 1");
        tester.startStream((short)1);
        System.out.println("Starting stream 2");
        tester.startStream((short)2);
        System.out.println("Starting stream 3");
        tester.startStream((short)3);
    }

    class ReaderThread
    extends Thread {
        ObjectInputStream is;
        short id;

        ReaderThread(short id) throws IOException {
            super("ReaderThread");
            this.is = new ObjectInputStream(new BufferedInputStream(MultiplexorTest.this.demux.getStream(id)));
            this.id = id;
        }

        public void run() {
            try {
                for (int i = 0; i < 1000; ++i) {
                    long t = this.is.readLong();
                    this.is.readObject();
                    t = System.currentTimeMillis() - t;
                    System.out.println("" + this.id + ": Packet " + i + " Latency : " + (double)t / 1000.0);
                    System.out.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class WriterThread
    extends Thread {
        ObjectOutputStream os;
        short id;

        WriterThread(short id) throws IOException {
            super("WriterThread");
            this.os = new ObjectOutputStream(new BufferedOutputStream(MultiplexorTest.this.mux.getStream(id)));
            this.os.flush();
        }

        public void run() {
            try {
                for (int i = 0; i < 1000; ++i) {
                    this.os.writeLong(System.currentTimeMillis());
                    this.os.writeObject(PAY_LOAD);
                    this.os.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

