/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.SharedInterceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationException;

public abstract class AbstractInterceptor
implements Interceptor {
    protected String name = "<no name>";
    protected boolean isShared = false;
    protected Logger log;
    static /* synthetic */ Class class$org$jboss$mx$server$Invocation;

    public AbstractInterceptor() {
        this.log = Logger.getLogger(this.getClass());
    }

    public AbstractInterceptor(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        AbstractInterceptor ic = invocation.nextInterceptor();
        if (ic == null) {
            return invocation.dispatch();
        }
        if (ic.isShared()) {
            SharedInterceptor shared = (SharedInterceptor)((Object)ic);
            MBeanServer server = shared.getMBeanServer();
            ObjectName name = shared.getObjectName();
            try {
                return server.invoke(name, "invoke", new Object[]{invocation}, new String[]{(class$org$jboss$mx$server$Invocation == null ? (class$org$jboss$mx$server$Invocation = AbstractInterceptor.class$("org.jboss.mx.server.Invocation")) : class$org$jboss$mx$server$Invocation).getName()});
            }
            catch (MBeanException e) {
                if (e.getTargetException() instanceof InvocationException) {
                    throw (InvocationException)e.getTargetException();
                }
                throw new InvocationException(e);
            }
            catch (Throwable t) {
                throw new InvocationException(t);
            }
        }
        return ic.invoke(invocation);
    }

    public String getName() {
        return this.name;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void init() throws Exception {
    }

    public void start() {
    }

    public void stop() throws Exception {
    }

    public void destroy() {
    }

    public String toString() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        return className.substring(index < 0 ? 0 : index) + "[name=" + this.name + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

