/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoader;

public class BasicLoaderRepository
extends LoaderRepository {
    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClassWithout(null, className);
    }

    public Class loadClassWithout(ClassLoader skipLoader, String className) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)nativeClassBySignature.get(className);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        if (ctxLoader != skipLoader) {
            try {
                clazz = ctxLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            return clazz;
        }
        Iterator it = loaders.iterator();
        while (it.hasNext()) {
            ClassLoader cl = (ClassLoader)it.next();
            if (cl == skipLoader) continue;
            try {
                clazz = cl.loadClass(className);
                return clazz;
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    public void addClassLoader(ClassLoader cl) {
        loaders.add(cl);
    }

    public boolean addClassLoaderURL(ClassLoader cl, URL url) {
        return false;
    }

    public void removeClassLoader(ClassLoader cl) {
        loaders.remove(cl);
    }

    public UnifiedClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader ucl = new UnifiedClassLoader(url);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public UnifiedClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader ucl = new UnifiedClassLoader(url, origURL);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException {
        throw new ClassNotFoundException("loadClass(String,boolean,ClassLoader) not supported");
    }

    public URL getResource(String name, ClassLoader cl) {
        URL res = null;
        if (cl instanceof UnifiedClassLoader) {
            UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
            res = ucl.getResourceLocally(name);
        } else {
            res = cl.getResource(name);
        }
        return res;
    }

    public void getResources(String name, ClassLoader cl, List urls) {
        Enumeration resURLs = null;
        try {
            if (cl instanceof UnifiedClassLoader) {
                UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
                resURLs = ucl.findResourcesLocally(name);
            } else {
                resURLs = cl.getResources(name);
            }
            while (resURLs.hasMoreElements()) {
                urls.add(resURLs.nextElement());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

