/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.server.ServerConstants;
import org.jboss.util.loading.Translator;

public abstract class LoaderRepository
implements ServerConstants,
ClassLoaderRepository {
    protected static Vector loaders = new Vector();
    protected static LoaderRepository instance = null;
    protected Translator translator = null;
    private ConcurrentReaderHashMap classes = new ConcurrentReaderHashMap();
    protected static final HashMap nativeClassBySignature;
    private static final Logger log;
    static /* synthetic */ Class class$org$jboss$mx$loading$LoaderRepository;

    public static synchronized LoaderRepository getDefaultLoaderRepository() {
        if (instance != null) {
            return instance;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String className = System.getProperty("jbossmx.loader.repository.class", "org.jboss.mx.loading.UnifiedLoaderRepository3");
        System.setProperty("jbossmx.loader.repository.class", className);
        try {
            Class<?> repository = cl.loadClass(className);
            instance = (LoaderRepository)repository.newInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new Error("Cannot instantiate default loader repository class. Class " + className + " not found.");
        }
        catch (ClassCastException e) {
            throw new Error("Cannot instantiate default loader repository class. The target class is not an instance of LoaderRepository interface.");
        }
        catch (Exception e) {
            throw new Error("Error creating default loader repository: " + e.toString());
        }
    }

    public Vector getLoaders() {
        return loaders;
    }

    public URL[] getURLs() {
        return null;
    }

    public Class getCachedClass(String classname) {
        return (Class)this.classes.get(classname);
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator t) {
        this.translator = t;
    }

    public abstract UnifiedClassLoader newClassLoader(URL var1, boolean var2) throws Exception;

    public abstract UnifiedClassLoader newClassLoader(URL var1, URL var2, boolean var3) throws Exception;

    public abstract Class loadClass(String var1) throws ClassNotFoundException;

    public Class loadClassBefore(ClassLoader cl, String className) throws ClassNotFoundException {
        throw new UnsupportedOperationException("NYI");
    }

    public abstract Class loadClass(String var1, boolean var2, ClassLoader var3) throws ClassNotFoundException;

    public abstract URL getResource(String var1, ClassLoader var2);

    public abstract void getResources(String var1, ClassLoader var2, List var3);

    public abstract Class loadClassWithout(ClassLoader var1, String var2) throws ClassNotFoundException;

    public abstract void addClassLoader(ClassLoader var1);

    public abstract boolean addClassLoaderURL(ClassLoader var1, URL var2);

    public abstract void removeClassLoader(ClassLoader var1);

    public static final Class getNativeClassForName(String className) {
        return (Class)nativeClassBySignature.get(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            Object prevClass = this.classes.put(name, cls);
            if (log.isTraceEnabled()) {
                log.trace("cacheLoadedClass, classname: " + name + ", class: " + cls + ", ucl: " + cl);
            }
        }
    }

    void clear() {
        this.classes.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = Logger.getLogger(class$org$jboss$mx$loading$LoaderRepository == null ? (class$org$jboss$mx$loading$LoaderRepository = LoaderRepository.class$("org.jboss.mx.loading.LoaderRepository")) : class$org$jboss$mx$loading$LoaderRepository);
        nativeClassBySignature = new HashMap();
        nativeClassBySignature.put(Boolean.TYPE.getName(), Boolean.TYPE);
        nativeClassBySignature.put(Byte.TYPE.getName(), Byte.TYPE);
        nativeClassBySignature.put(Character.TYPE.getName(), Character.TYPE);
        nativeClassBySignature.put(Double.TYPE.getName(), Double.TYPE);
        nativeClassBySignature.put(Float.TYPE.getName(), Float.TYPE);
        nativeClassBySignature.put(Integer.TYPE.getName(), Integer.TYPE);
        nativeClassBySignature.put(Long.TYPE.getName(), Long.TYPE);
        nativeClassBySignature.put(Short.TYPE.getName(), Short.TYPE);
        nativeClassBySignature.put(Void.TYPE.getName(), Void.TYPE);
    }
}

