/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import org.jboss.axis.ConfigurationException;
import org.jboss.axis.MessageContext;
import org.jboss.axis.deployment.wsdd.WSDDConstants;
import org.jboss.axis.deployment.wsdd.WSDDDeployment;
import org.jboss.axis.deployment.wsdd.WSDDException;
import org.jboss.axis.deployment.wsdd.WSDDProvider;
import org.jboss.axis.deployment.wsdd.WSDDService;
import org.jboss.axis.deployment.wsdd.WSDDTypeMapping;
import org.jboss.axis.description.ServiceDesc;
import org.jboss.axis.encoding.TypeMappingRegistry;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.logging.Logger;
import org.jboss.net.axis.ParameterizableDeserializerFactory;
import org.jboss.net.axis.ServiceClassLoaderAwareWSDDHandlerProvider;
import org.jboss.net.axis.TypeMapping;
import org.w3c.dom.Element;

public class Deployment
extends WSDDDeployment {
    private static Logger log = Logger.getLogger(class$org$jboss$net$axis$Deployment == null ? (class$org$jboss$net$axis$Deployment = Deployment.class$("org.jboss.net.axis.Deployment")) : class$org$jboss$net$axis$Deployment);
    protected ClassLoader deploymentLoader;
    protected List typeMappings = new ArrayList();
    protected boolean tmrCreated;
    static /* synthetic */ Class class$org$jboss$net$axis$Deployment;

    protected Deployment(Element e, ClassLoader loader) throws WSDDException {
        super(e);
        this.deploymentLoader = loader;
        Element[] elements = this.getChildElements(e, "typeMapping");
        for (int i = 0; i < elements.length; ++i) {
            TypeMapping mapping = new TypeMapping(elements[i]);
            this.deployTypeMapping(mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deployment makeSafeDeployment(Element e, ClassLoader loader) throws WSDDException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Deployment deployment = new Deployment(e, loader);
            return deployment;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected ClassLoader getDeploymentLoader() {
        return this.deploymentLoader;
    }

    protected static Deployment getDeployment(WSDDService service) {
        return (Deployment)((Object)service.getParametersTable().get((Object)"org.jboss.net.axis.SERVICE_DEPLOYMENT_PARAMETER"));
    }

    public void deployService(WSDDService service) {
        service.getParametersTable().put((Object)"org.jboss.net.axis.SERVICE_DEPLOYMENT_PARAMETER", (Object)this);
        if (service.getHandlerInfoChain() != null && "true".equals(service.getParameter("org.jboss.net.axis.USE_PROVIDER_HANDLER_CHAIN"))) {
            service.getParametersTable().put((Object)"org.jboss.net.axis.PROVIDER_HANDLER_CHAIN", (Object)service.getHandlerInfoChain());
            service.setParameter("org.jboss.net.axis.USE_PROVIDER_HANDLER_CHAIN", "false");
            service.setHandlerInfoChain(null);
        }
        super.deployService(service);
    }

    public void deployTypeMapping(WSDDTypeMapping typeMapping) throws WSDDException {
        if (typeMapping instanceof TypeMapping) {
            if (this.tmrCreated) {
                try {
                    this.installTypeMappingWithOptions((TypeMapping)typeMapping);
                }
                catch (ConfigurationException e) {
                    throw new WSDDException("Could not install type mapping with options." + (Object)((Object)e));
                }
            } else {
                this.typeMappings.add(typeMapping);
            }
        }
    }

    public Iterator getDeployedServices() throws ConfigurationException {
        ArrayList<ServiceDesc> serviceDescs = new ArrayList<ServiceDesc>();
        WSDDService[] services = this.getServices();
        for (int count = 0; count < services.length; ++count) {
            try {
                serviceDescs.add(this.getService(services[count].getQName()).getServiceDescription());
                continue;
            }
            catch (ConfigurationException ex) {
                log.debug("Ingoring non-fatal exception: ", ex);
            }
        }
        return serviceDescs.iterator();
    }

    private SOAPService getServiceInternal(QName serviceName) throws ConfigurationException {
        ClassLoader deploymentLoader = this.getDeploymentLoader();
        Thread.currentThread().setContextClassLoader(deploymentLoader);
        MessageContext currentContext = MessageContext.getCurrentContext();
        if (currentContext != null) {
            currentContext.setClassLoader(deploymentLoader);
        }
        return super.getService(serviceName);
    }

    public SOAPService getService(QName serviceName) throws ConfigurationException {
        WSDDService wsddService = this.getWSDDService(serviceName);
        if (wsddService != null) {
            return Deployment.getDeployment(wsddService).getServiceInternal(serviceName);
        }
        return null;
    }

    public SOAPService getServiceByNamespaceURI(String arg0) throws ConfigurationException {
        return null;
    }

    public void deployToRegistry(WSDDDeployment arg0) throws ConfigurationException {
        super.deployToRegistry(arg0);
        this.configureEngine(arg0.getEngine());
        this.getTypeMappingRegistry().delegate(arg0.getTypeMappingRegistry());
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        if (!this.tmrCreated) {
            this.tmrCreated = true;
            Iterator allTms = this.typeMappings.iterator();
            while (allTms.hasNext()) {
                TypeMapping nextMapping = (TypeMapping)((Object)allTms.next());
                this.installTypeMappingWithOptions(nextMapping);
            }
            this.tmrCreated = true;
        }
        return super.getTypeMappingRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installTypeMappingWithOptions(TypeMapping nextMapping) throws ConfigurationException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getDeploymentLoader());
        try {
            super.deployTypeMapping((WSDDTypeMapping)nextMapping);
            org.jboss.axis.encoding.TypeMapping axisMapping = (org.jboss.axis.encoding.TypeMapping)this.getTypeMappingRegistry().getTypeMapping(nextMapping.getEncodingStyle());
            DeserializerFactory dser = axisMapping.getDeserializer(nextMapping.getQName());
            if (dser instanceof ParameterizableDeserializerFactory) {
                ((ParameterizableDeserializerFactory)dser).setOptions(nextMapping.getParametersTable());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        WSDDProvider.registerProvider((QName)WSDDConstants.QNAME_HANDLER_PROVIDER, (WSDDProvider)new ServiceClassLoaderAwareWSDDHandlerProvider());
    }
}

