/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.httpclient.HttpException;
import org.apache.util.HttpURL;
import org.apache.webdav.lib.WebdavResource;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerBase;

public class DavURLLister
extends URLListerBase {
    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter) throws IOException {
        return this.listMembers(baseUrl, filter, false);
    }

    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter, boolean scanNonDottedSubDirs) throws IOException {
        WebdavResource resource = null;
        try {
            resource = new WebdavResource(baseUrl.toString());
            WebdavResource[] resources = resource.listWebdavResources();
            ArrayList<URL> urls = new ArrayList<URL>(resources.length);
            for (int i = 0; i < resources.length; ++i) {
                WebdavResource member = resources[i];
                HttpURL httpURL = member.getHttpURL();
                if (!filter.accept(baseUrl, httpURL.getName())) continue;
                String url = httpURL.getUnescapedHttpURL();
                if (member.isCollection()) {
                    if (!url.endsWith("/")) {
                        url = url + "/";
                    }
                    if (scanNonDottedSubDirs && DavURLLister.getFilePartFromUrl(httpURL.toURL()).indexOf(".") == -1) {
                        URL subUrl = new URL(url);
                        urls.addAll(this.listMembers(subUrl, filter, scanNonDottedSubDirs));
                        continue;
                    }
                    urls.add(new URL(url));
                    continue;
                }
                urls.add(new URL(url));
            }
            ArrayList<URL> arrayList = urls;
            return arrayList;
        }
        catch (HttpException e) {
            throw new IOException(e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            if (resource != null) {
                resource.close();
            }
        }
    }

    protected static final String getFilePartFromUrl(URL source) {
        int length;
        String name = source.getPath();
        if (name.charAt((length = name.length()) - 1) == '/') {
            int start = name.lastIndexOf("/", length - 2);
            return name.substring(start, length - 2);
        }
        int start = name.lastIndexOf("/");
        return name.substring(start);
    }
}

