/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    static final long serialVersionUID = -4175838107150528488L;
    public static final int JBOSS_FORMAT_ID = 257;
    private final int hash;
    private final byte[] globalId;
    private final byte[] branchId;

    static String toString(Xid id) {
        if (id == null) {
            return "[NULL Xid]";
        }
        String s = id.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        s = s + " [FormatId=" + id.getFormatId() + ", GlobalId=" + new String(id.getGlobalTransactionId()).trim() + ", BranchQual=" + new String(id.getBranchQualifier()).trim() + "]";
        return s;
    }

    public XidImpl(byte[] globalId, byte[] branchId, int hash) {
        this.globalId = globalId;
        this.branchId = branchId;
        this.hash = hash;
    }

    public XidImpl(Xid xid, byte[] branchId) {
        if (xid instanceof XidImpl) {
            this.hash = ((XidImpl)xid).hash;
            this.globalId = ((XidImpl)xid).globalId;
        } else {
            this.hash = xid.hashCode();
            this.globalId = xid.getGlobalTransactionId();
        }
        this.branchId = branchId;
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    public byte[] getBranchQualifier() {
        if (this.branchId.length == 0) {
            return this.branchId;
        }
        return (byte[])this.branchId.clone();
    }

    public int getFormatId() {
        return 257;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XidImpl) {
            int i;
            XidImpl other = (XidImpl)obj;
            if (this.globalId.length != other.globalId.length || this.branchId.length != other.branchId.length) {
                return false;
            }
            for (i = 0; i < this.globalId.length; ++i) {
                if (this.globalId[i] == other.globalId[i]) continue;
                return false;
            }
            for (i = 0; i < this.branchId.length; ++i) {
                if (this.branchId[i] == other.branchId[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return XidImpl.toString(this);
    }

    byte[] getInternalGlobalTransactionId() {
        return this.globalId;
    }
}

