/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xml.binding.Content;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.GenericObjectModelFactory;
import org.xml.sax.Attributes;

public class ObjectModelBuilder
implements ContentNavigator {
    private static final Logger log = Logger.getLogger(class$org$jboss$xml$binding$ObjectModelBuilder == null ? (class$org$jboss$xml$binding$ObjectModelBuilder = ObjectModelBuilder.class$("org.jboss.xml.binding.ObjectModelBuilder")) : class$org$jboss$xml$binding$ObjectModelBuilder);
    private static final Object IGNORED = new Object();
    private Object root;
    private Stack all = new StackImpl();
    private Stack accepted = new StackImpl();
    private GenericObjectModelFactory defaultFactory;
    private Map factoriesToNs = Collections.EMPTY_MAP;
    private Map prefixToUri = new HashMap();
    private Content content;
    private StringBuffer value = new StringBuffer();
    static /* synthetic */ Class class$org$jboss$xml$binding$ObjectModelBuilder;

    public void mapFactoryToNamespace(GenericObjectModelFactory factory, String namespaceUri) {
        if (this.factoriesToNs == Collections.EMPTY_MAP) {
            this.factoriesToNs = new HashMap();
        }
        this.factoriesToNs.put(namespaceUri, factory);
    }

    public Object build(GenericObjectModelFactory defaultFactory, Object root, Content content) throws Exception {
        this.defaultFactory = defaultFactory;
        this.content = content;
        this.all.clear();
        this.accepted.clear();
        this.value.delete(0, this.value.length());
        boolean popRoot = false;
        if (root != null) {
            this.all.push(root);
            this.accepted.push(root);
            popRoot = true;
        }
        content.build(this);
        if (popRoot) {
            root = this.all.pop();
            this.accepted.pop();
        }
        return this.root;
    }

    public Map getPrefixToNamespaceMap() {
        return Collections.unmodifiableMap(this.prefixToUri);
    }

    public String resolveNamespacePrefix(String prefix) {
        LinkedList prefixStack = (LinkedList)this.prefixToUri.get(prefix);
        String uri = prefixStack != null && !prefixStack.isEmpty() ? (String)prefixStack.getFirst() : null;
        return uri;
    }

    public QName resolveQName(String value) {
        StringTokenizer st = new StringTokenizer(value, ":");
        if (st.countTokens() == 1) {
            return new QName(value);
        }
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("Illegal QName: " + value);
        }
        String prefix = st.nextToken();
        String local = st.nextToken();
        String nsURI = this.resolveNamespacePrefix(prefix);
        return new QName(nsURI, local);
    }

    public String getChildContent(String namespaceURI, String qName) {
        return this.content.getChildContent(namespaceURI, qName);
    }

    public void startPrefixMapping(String prefix, String uri) {
        LinkedList<String> prefixStack = (LinkedList<String>)this.prefixToUri.get(prefix);
        if (prefixStack == null || prefixStack.isEmpty()) {
            prefixStack = new LinkedList<String>();
            this.prefixToUri.put(prefix, prefixStack);
        }
        prefixStack.addFirst(uri);
    }

    public void endPrefixMapping(String prefix) {
        LinkedList prefixStack = (LinkedList)this.prefixToUri.get(prefix);
        if (prefixStack != null) {
            prefixStack.removeFirst();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        Object element;
        Object parent = null;
        if (!this.accepted.isEmpty()) {
            parent = this.accepted.peek();
        }
        GenericObjectModelFactory factory = this.getFactory(namespaceURI);
        if (this.root == null) {
            this.root = element = factory.newRoot(parent, this, namespaceURI, localName, atts);
        } else {
            element = factory.newChild(parent, this, namespaceURI, localName, atts);
        }
        if (element == null) {
            this.all.push(IGNORED);
            if (log.isTraceEnabled()) {
                log.trace("ignored " + namespaceURI + ':' + qName);
            }
        } else {
            this.all.push(element);
            this.accepted.push(element);
            if (log.isTraceEnabled()) {
                log.trace("accepted " + namespaceURI + ':' + qName);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        Object element;
        GenericObjectModelFactory factory = null;
        if (this.value.length() > 0) {
            try {
                element = this.accepted.peek();
            }
            catch (NoSuchElementException e) {
                log.error("value=" + this.value, e);
                throw e;
            }
            factory = this.getFactory(namespaceURI);
            factory.setValue(element, this, namespaceURI, localName, this.value.toString().trim());
            this.value.delete(0, this.value.length());
        }
        if ((element = this.all.pop()) != IGNORED) {
            Object parent;
            element = this.accepted.pop();
            Object object = parent = this.accepted.isEmpty() ? null : this.accepted.peek();
            if (parent != null) {
                if (factory == null) {
                    factory = this.getFactory(namespaceURI);
                }
                factory.addChild(parent, element, this, namespaceURI, localName);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.value.append(ch, start, length);
    }

    private GenericObjectModelFactory getFactory(String namespaceUri) {
        GenericObjectModelFactory factory = (GenericObjectModelFactory)this.factoriesToNs.get(namespaceUri);
        if (factory == null) {
            factory = this.defaultFactory;
        }
        return factory;
    }

    static Object invokeFactory(Object factory, Method method, Object[] args) {
        try {
            return method.invoke(factory, args);
        }
        catch (InvocationTargetException e) {
            log.error("Failed to invoke method " + method.getName(), e.getTargetException());
            throw new IllegalStateException("Failed to invoke method " + method.getName());
        }
        catch (Exception e) {
            log.error("Failed to invoke method " + method.getName(), e);
            throw new IllegalStateException("Failed to invoke method " + method.getName());
        }
    }

    static Method getMethodForElement(Object factory, String name, Class[] params) {
        Method method = null;
        try {
            method = factory.getClass().getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return method;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StackImpl
    implements Stack {
        private LinkedList list = new LinkedList();

        private StackImpl() {
        }

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.addLast(o);
        }

        public Object pop() {
            return this.list.removeLast();
        }

        public Object peek() {
            return this.list.getLast();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    private static interface Stack {
        public void clear();

        public void push(Object var1);

        public Object pop();

        public Object peek();

        public boolean isEmpty();
    }
}

