/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter;

import java.util.concurrent.ConcurrentHashMap;
import me.zhyd.hunter.config.HunterConfig;
import me.zhyd.hunter.enums.ExitWayEnum;
import me.zhyd.hunter.exception.HunterException;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.processor.PageProcessor;

public class Hunter
extends Spider {
    public static final ConcurrentHashMap<String, Hunter> SPIDER_BUCKET = new ConcurrentHashMap();
    private HunterConfig config;
    private String hunterId;
    private volatile long startTime = 0L;

    private Hunter(PageProcessor pageProcessor, HunterConfig config, String hunterId) {
        super(pageProcessor);
        this.config = config;
        this.hunterId = hunterId;
        SPIDER_BUCKET.put(hunterId, this);
    }

    public static Hunter create(PageProcessor pageProcessor, HunterConfig config, String hunterId) {
        return new Hunter(pageProcessor, config, hunterId);
    }

    public static Hunter getHunter(String hunterId) {
        if (StringUtils.isEmpty((CharSequence)hunterId)) {
            throw new HunterException("HunterId\uff1a[" + hunterId + "]\u4e3a\u7a7a\uff0c\u8bf7\u6307\u5b9aHunterId");
        }
        Hunter hunter = SPIDER_BUCKET.get(hunterId);
        if (null == hunter) {
            throw new HunterException("\u5f53\u524d\u6ca1\u6709\u6b63\u5728\u8fd0\u884c\u7684\u722c\u866b\uff01HunterId\uff1a[" + hunterId + "]");
        }
        return hunter;
    }

    protected void onSuccess(Request request) {
        super.onSuccess(request);
        if (this.getStatus() == Spider.Status.Running && ExitWayEnum.DURATION.toString().equals(this.config.getExitWay()) && this.startTime < System.currentTimeMillis()) {
            this.stop();
        }
    }

    public void run() {
        if (ExitWayEnum.DURATION.toString().equals(this.config.getExitWay())) {
            this.startTime = System.currentTimeMillis() + (long)(this.config.getCount() * 1000);
        }
        super.run();
    }

    protected void onError(Request request) {
        super.onError(request);
    }

    public void close() {
        super.close();
        SPIDER_BUCKET.remove(this.hunterId);
    }

    public void stop() {
        Spider.Status status = this.getStatus();
        if (!status.equals((Object)Spider.Status.Running)) {
            if (status.equals((Object)Spider.Status.Init)) {
                throw new HunterException("\u722c\u866b\u6b63\u5728\u521d\u59cb\u5316\uff01HunterId\uff1a[" + this.hunterId + "]");
            }
            throw new HunterException("\u5f53\u524d\u6ca1\u6709\u6b63\u5728\u8fd0\u884c\u7684\u722c\u866b\uff01HunterId\uff1a[" + this.hunterId + "]");
        }
        super.stop();
        SPIDER_BUCKET.remove(this.hunterId);
    }
}

