/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.config.platform;

import me.zhyd.hunter.config.platform.CnblogsPlatform;
import me.zhyd.hunter.config.platform.CsdnPlatform;
import me.zhyd.hunter.config.platform.ImoocPlatform;
import me.zhyd.hunter.config.platform.IteyePlatform;
import me.zhyd.hunter.config.platform.JuejinPlatform;
import me.zhyd.hunter.config.platform.V2exPlatform;
import me.zhyd.hunter.util.PlatformUtil;

public enum Platform {
    CSDN("csdn", "csdn.net", CsdnPlatform.class),
    ITEYE("iteye", "iteye.com", IteyePlatform.class),
    IMOOC("imooc", "imooc.com", ImoocPlatform.class),
    CNBLOGS("cnblogs", "cnblogs.com", CnblogsPlatform.class),
    JUEJIN("juejin", "juejin.im", JuejinPlatform.class),
    V2EX("v2ex", "v2ex.com", V2exPlatform.class);

    private String platform;
    private String host;
    private Class clazz;

    private Platform(String platform, String host, Class clazz) {
        this.platform = platform;
        this.host = host;
        this.clazz = clazz;
    }

    public static Platform getPlatformByUrl(String url) {
        if (null == url) {
            return null;
        }
        String host = PlatformUtil.getHost(url);
        if (host == null) {
            return null;
        }
        for (Platform value : Platform.values()) {
            if (!host.contains(value.getHost())) continue;
            return value;
        }
        return null;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getHost() {
        return this.host;
    }

    public Class getClazz() {
        return this.clazz;
    }
}

