/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.processor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.zhyd.hunter.Hunter;
import me.zhyd.hunter.config.HunterConfig;
import me.zhyd.hunter.downloader.HttpClientDownloader;
import me.zhyd.hunter.entity.VirtualArticle;
import me.zhyd.hunter.processor.HunterProcessor;
import me.zhyd.hunter.scheduler.BlockingQueueScheduler;
import me.zhyd.hunter.util.HunterPrintWriter;
import org.apache.commons.collections.CollectionUtils;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.proxy.Proxy;
import us.codecraft.webmagic.proxy.ProxyProvider;
import us.codecraft.webmagic.proxy.SimpleProxyProvider;
import us.codecraft.webmagic.scheduler.Scheduler;

public class BlogHunterProcessor
extends HunterProcessor {
    public BlogHunterProcessor(String url, boolean convertImage) {
        super(url, convertImage);
    }

    public BlogHunterProcessor(String url, boolean convertImage, HunterPrintWriter writer) {
        super(url, convertImage, writer);
    }

    public BlogHunterProcessor(HunterConfig config) {
        super(config);
    }

    public BlogHunterProcessor(HunterConfig config, String uuid) {
        super(config, uuid);
    }

    public BlogHunterProcessor(HunterConfig config, HunterPrintWriter writer, String uuid) {
        super(config, writer, uuid);
    }

    @Override
    public CopyOnWriteArrayList<VirtualArticle> execute() {
        List<String> errors = this.validateModel(this.config);
        if (CollectionUtils.isNotEmpty(errors)) {
            this.writer.print("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01\u8bf7\u4f9d\u636e\u4e0b\u65b9\u63d0\u793a\uff0c\u68c0\u67e5\u8f93\u5165\u53c2\u6570\u662f\u5426\u6b63\u786e......");
            for (String error : errors) {
                this.writer.print(">> " + error);
            }
            return null;
        }
        CopyOnWriteArrayList<VirtualArticle> virtualArticles = new CopyOnWriteArrayList<VirtualArticle>();
        Hunter spider = Hunter.create(this, this.config, this.uuid);
        spider.addUrl(this.config.getEntryUrls().toArray(new String[0])).setScheduler((Scheduler)new BlockingQueueScheduler(this.config)).addPipeline((resultItems, task) -> this.process(resultItems, virtualArticles, spider)).setDownloader((Downloader)new HttpClientDownloader()).thread(this.config.getThreadCount());
        if (!CollectionUtils.isEmpty(this.config.getProxyList())) {
            HttpClientDownloader httpClientDownloader = new HttpClientDownloader();
            SimpleProxyProvider provider = SimpleProxyProvider.from((Proxy[])this.config.getProxyList().toArray(new Proxy[0]));
            httpClientDownloader.setProxyProvider((ProxyProvider)provider);
            spider.setDownloader((Downloader)httpClientDownloader);
        }
        spider.run();
        return virtualArticles;
    }
}

