/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import me.zhyd.hunter.entity.ImageLink;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

public class CommonUtil {
    private static final Pattern PATTERN = Pattern.compile("<img[^>]+src\\s*=\\s*['\"]([^'\"]+)['\"][^'\"]+data-original\\s*=\\s*['\"]([^'\"]+)['\"][^>]*>|<img[^>]+data-original\\s*=\\s*['\"]([^'\"]+)['\"][^'\"]+src\\s*=\\s*['\"]([^'\"]+)['\"][^>]*>|<img[^>]+src\\s*=\\s*['\"]([^'\"]+)['\"][^>]*>");

    public static String getRealDescription(String description, String content) {
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            return description.replaceAll("\r\n| ", "");
        }
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            return (content = Jsoup.clean((String)content.trim(), (Whitelist)Whitelist.simpleText())).length() > 100 ? content.substring(0, 100) : content;
        }
        return null;
    }

    public static String getRealKeywords(String keywords) {
        String keys = StringUtils.isNotEmpty((CharSequence)keywords) && !"null".equals(keywords) ? keywords.trim().replaceAll(" +|\uff0c", ",").replaceAll(",,", ",") : null;
        return StringUtils.isEmpty(keys) ? null : Jsoup.clean(keys, (Whitelist)Whitelist.simpleText());
    }

    public static String formatHtml(String html) {
        if (StringUtils.isEmpty((CharSequence)html)) {
            return null;
        }
        String lazyloadFormat = "<img src=\"%s\" title=\"%s\" alt=\"%s\">";
        Html pageHtml = CommonUtil.getHtml(html);
        List imgSelectables = pageHtml.$("img").nodes();
        for (Selectable imgSelectable : imgSelectables) {
            String oldImg = imgSelectable.get();
            String newImg = String.format(lazyloadFormat, CommonUtil.getRealImgUrl(imgSelectable), imgSelectable.xpath("//img/@title").get(), imgSelectable.xpath("//img/@alt").get());
            html = html.replace(oldImg, newImg);
        }
        return html;
    }

    private static String getRealImgUrl(Selectable selectable) {
        String realImgUrl = selectable.xpath("//img/@data-original").get();
        if (StringUtils.isEmpty((CharSequence)realImgUrl) && StringUtils.isEmpty((CharSequence)(realImgUrl = selectable.xpath("//img/@data-src").get()))) {
            realImgUrl = selectable.xpath("//img/@src").get();
        }
        if (StringUtils.isNotEmpty((CharSequence)realImgUrl) && realImgUrl.contains("?")) {
            realImgUrl = realImgUrl.substring(0, realImgUrl.indexOf("?"));
        }
        return realImgUrl;
    }

    public static Set<ImageLink> getAllImageLink(String html) {
        if (StringUtils.isEmpty((CharSequence)html)) {
            return null;
        }
        HashSet<ImageLink> imageLinks = new HashSet<ImageLink>();
        ImageLink imageLink = null;
        Html pageHtml = CommonUtil.getHtml(html);
        List imgSelectables = pageHtml.$("img").nodes();
        for (Selectable imgSelectable : imgSelectables) {
            String newImgSrc = CommonUtil.getRealImgUrl(imgSelectable);
            imageLink = new ImageLink(newImgSrc);
            imageLinks.add(imageLink);
        }
        return imageLinks;
    }

    private static Html getHtml(String html) {
        Page page = new Page();
        page.setRequest(new Request(""));
        page.setRawText(html);
        return page.getHtml();
    }
}

