/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.util;

import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HunterPrintWriter {
    private static final Logger log = LoggerFactory.getLogger(HunterPrintWriter.class);
    private String jsoupCallback = "<script>parent.printMessage('%s');</script>";
    private PrintWriter writer;

    public HunterPrintWriter() {
    }

    public HunterPrintWriter(PrintWriter writer, String jsoupCallback) {
        this.writer = writer;
        if (null != jsoupCallback) {
            this.jsoupCallback = jsoupCallback;
        }
    }

    public HunterPrintWriter(PrintWriter writer) {
        this(writer, null);
    }

    public HunterPrintWriter print(String ... msgs) {
        for (String msg : msgs) {
            if (!msg.equals("shutdown")) {
                msg = "[ hunter ] " + msg;
            }
            log.info(msg);
            if (null == this.writer) continue;
            this.writer.print(String.format(this.jsoupCallback, msg));
            this.writer.flush();
        }
        return this;
    }

    public void shutdown() {
        this.print("bye~~", "shutdown");
        if (null != this.writer) {
            this.writer.close();
            this.writer = null;
        }
    }
}

