/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.xkcoding.http.HttpUtil;
import com.xkcoding.http.support.HttpHeader;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthLinkedinRequest
extends AuthDefaultRequest {
    public AuthLinkedinRequest(AuthConfig config) {
        super(config, AuthDefaultSource.LINKEDIN);
    }

    public AuthLinkedinRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.LINKEDIN, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Host", "api.linkedin.com");
        httpHeader.add("Connection", "Keep-Alive");
        httpHeader.add("Authorization", "Bearer " + accessToken);
        String response = HttpUtil.get((String)this.userInfoUrl(authToken), null, (HttpHeader)httpHeader, (boolean)false);
        JSONObject userInfoObject = JSONObject.parseObject((String)response);
        this.checkResponse(userInfoObject);
        String userName = this.getUserName(userInfoObject);
        String avatar = this.getAvatar(userInfoObject);
        String email = this.getUserEmail(accessToken);
        return AuthUser.builder().uuid(userInfoObject.getString("id")).username(userName).nickname(userName).avatar(avatar).email(email).token(authToken).gender(AuthUserGender.UNKNOWN).source(this.source.toString()).build();
    }

    private String getUserName(JSONObject userInfoObject) {
        String firstName = userInfoObject.containsKey((Object)"localizedFirstName") ? userInfoObject.getString("localizedFirstName") : this.getUserName(userInfoObject, "firstName");
        String lastName = userInfoObject.containsKey((Object)"localizedLastName") ? userInfoObject.getString("localizedLastName") : this.getUserName(userInfoObject, "lastName");
        return firstName + " " + lastName;
    }

    private String getAvatar(JSONObject userInfoObject) {
        JSONArray displayImageElements;
        String avatar = null;
        JSONObject profilePictureObject = userInfoObject.getJSONObject("profilePicture");
        if (profilePictureObject.containsKey((Object)"displayImage~") && null != (displayImageElements = profilePictureObject.getJSONObject("displayImage~").getJSONArray("elements")) && displayImageElements.size() > 0) {
            JSONObject largestImageObj = displayImageElements.getJSONObject(displayImageElements.size() - 1);
            avatar = largestImageObj.getJSONArray("identifiers").getJSONObject(0).getString("identifier");
        }
        return avatar;
    }

    private String getUserEmail(String accessToken) {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Host", "api.linkedin.com");
        httpHeader.add("Connection", "Keep-Alive");
        httpHeader.add("Authorization", "Bearer " + accessToken);
        String emailResponse = HttpUtil.get((String)"https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))", null, (HttpHeader)httpHeader, (boolean)false);
        JSONObject emailObj = JSONObject.parseObject((String)emailResponse);
        this.checkResponse(emailObj);
        Object obj = JSONPath.eval((Object)emailObj, (String)"$['elements'][0]['handle~']['emailAddress']");
        return null == obj ? null : (String)obj;
    }

    private String getUserName(JSONObject userInfoObject, String nameKey) {
        JSONObject firstNameObj = userInfoObject.getJSONObject(nameKey);
        JSONObject localizedObj = firstNameObj.getJSONObject("localized");
        JSONObject preferredLocaleObj = firstNameObj.getJSONObject("preferredLocale");
        String firstName = localizedObj.getString(preferredLocaleObj.getString("language") + "_" + preferredLocaleObj.getString("country"));
        return firstName;
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        String refreshToken = oldToken.getRefreshToken();
        if (StringUtils.isEmpty(refreshToken)) {
            throw new AuthException(AuthResponseStatus.REQUIRED_REFRESH_TOKEN, this.source);
        }
        String refreshTokenUrl = this.refreshTokenUrl(refreshToken);
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(refreshTokenUrl)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"), this.source);
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Host", "www.linkedin.com");
        httpHeader.add("Content-Type", "application/x-www-form-urlencoded");
        String response = HttpUtil.post((String)accessTokenUrl, null, (HttpHeader)httpHeader);
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", "r_liteprofile%20r_emailaddress%20w_member_social").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("projection", "(id,firstName,lastName,profilePicture(displayImage~:playableStreams))").build();
    }
}

