/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.HttpUtil;
import java.text.MessageFormat;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.log.Log;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthMiRequest
extends AuthDefaultRequest {
    private static final String PREFIX = "&&&START&&&";

    public AuthMiRequest(AuthConfig config) {
        super(config, AuthDefaultSource.MI);
    }

    public AuthMiRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.MI, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    private AuthToken getToken(String accessTokenUrl) {
        String response = HttpUtil.get((String)accessTokenUrl);
        String jsonStr = response.replace(PREFIX, "");
        JSONObject accessTokenObject = JSONObject.parseObject((String)jsonStr);
        if (accessTokenObject.containsKey((Object)"error")) {
            throw new AuthException(accessTokenObject.getString("error_description"));
        }
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).scope(accessTokenObject.getString("scope")).tokenType(accessTokenObject.getString("token_type")).refreshToken(accessTokenObject.getString("refresh_token")).openId(accessTokenObject.getString("openId")).macAlgorithm(accessTokenObject.getString("mac_algorithm")).macKey(accessTokenObject.getString("mac_key")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String userResponse = this.doGetUserInfo(authToken);
        JSONObject userProfile = JSONObject.parseObject((String)userResponse);
        if ("error".equalsIgnoreCase(userProfile.getString("result"))) {
            throw new AuthException(userProfile.getString("description"));
        }
        JSONObject user = userProfile.getJSONObject("data");
        AuthUser authUser = AuthUser.builder().uuid(authToken.getOpenId()).username(user.getString("miliaoNick")).nickname(user.getString("miliaoNick")).avatar(user.getString("miliaoIcon")).email(user.getString("mail")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
        String emailPhoneUrl = MessageFormat.format("{0}?clientId={1}&token={2}", "https://open.account.xiaomi.com/user/phoneAndEmail", this.config.getClientId(), authToken.getAccessToken());
        String emailResponse = HttpUtil.get((String)emailPhoneUrl);
        JSONObject userEmailPhone = JSONObject.parseObject((String)emailResponse);
        if (!"error".equalsIgnoreCase(userEmailPhone.getString("result"))) {
            JSONObject emailPhone = userEmailPhone.getJSONObject("data");
            authUser.setEmail(emailPhone.getString("email"));
        } else {
            Log.warn("\u5c0f\u7c73\u5f00\u53d1\u5e73\u53f0\u6682\u65f6\u4e0d\u5bf9\u5916\u5f00\u653e\u7528\u6237\u624b\u673a\u53ca\u90ae\u7bb1\u4fe1\u606f\u7684\u83b7\u53d6");
        }
        return authUser;
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", "user/profile%20user/openIdV2%20user/phoneAndEmail").queryParam("skip_confirm", "false").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("clientId", this.config.getClientId()).queryParam("token", authToken.getAccessToken()).build();
    }
}

