/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import javax.sql.DataSource;
import net.lab1024.smartdb.SmartDb;
import net.lab1024.smartdb.SmartDbBuilder;
import net.lab1024.smartdb.SmartDbConfig;
import net.lab1024.smartdb.SmartDbImpl;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.SmartDbProxy;
import net.lab1024.smartdb.SmartDbWrapper;
import net.lab1024.smartdb.datasource.SmartDbDataSource;
import net.lab1024.smartdb.datasource.SmartDbDataSourceImpl;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.ext.SmartDbExtEnum;
import net.lab1024.smartdb.ext.spring.SmartDbDataSource4Spring;
import net.lab1024.smartdb.mapping.rowconvertor.CaseFormatRowConverter;
import net.lab1024.smartdb.sqlbuilder.convertor.ColumnNameConverter;
import net.lab1024.smartdb.sqlbuilder.convertor.DefaultColumnNameConverter;
import net.lab1024.smartdb.sqlbuilder.convertor.TableNameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartDbFactory {
    protected static Logger LOG = LoggerFactory.getLogger(SmartDbFactory.class);

    public static SmartDb build(SmartDbBuilder builder) {
        SmartDbFactory.validate(builder);
        SmartDbProxy proxy = SmartDbFactory.proxy(builder);
        SmartDbWrapper smartDbWrapper = new SmartDbWrapper();
        smartDbWrapper.setDb(proxy.getInstance());
        return smartDbWrapper;
    }

    private static void validate(SmartDbBuilder builder) {
        Class smartDbImplClass;
        TableNameConverter tableNameConverter;
        ColumnNameConverter columnNameConverter;
        if (builder.getSupportDatabaseType() == null) {
            throw new IllegalArgumentException("SupportDatabaseType cannot be null");
        }
        boolean isMasterDatasourceIsNull = false;
        if (builder.getMasterDataSource() == null) {
            isMasterDatasourceIsNull = true;
        }
        boolean isConnectInfoIsNull = false;
        if (builder.getUrl() == null && builder.getPassword() == null && builder.getUsername() == null && builder.getDriverClassName() == null) {
            isConnectInfoIsNull = true;
        }
        if (isConnectInfoIsNull && isMasterDatasourceIsNull) {
            throw new IllegalArgumentException("MasterDataSource cannot be null or connect info cannot be null");
        }
        if (builder.getSlaveDataSource() != null) {
            for (DataSource dataSource : builder.getSlaveDataSource()) {
                if (dataSource != null) continue;
                throw new IllegalArgumentException("SlaveDataSource cannot be null");
            }
        }
        if ((columnNameConverter = builder.getColumnNameConverter()) == null) {
            columnNameConverter = new DefaultColumnNameConverter();
            builder.setColumnNameConverter(columnNameConverter);
        }
        if ((tableNameConverter = builder.getTableNameConverter()) == null) {
            tableNameConverter = new TableNameConverter(){

                @Override
                public String classToTableName(Class<?> cls) {
                    return cls.getSimpleName();
                }
            };
            builder.setTableNameConverter(tableNameConverter);
        }
        if ((smartDbImplClass = builder.getSupportDatabaseType().getSmartDbNodeImplClass()) == null) {
            throw new IllegalArgumentException("SmartDbImplClass cannot be null");
        }
    }

    private static SmartDbNode buildSmartDbNode(SmartDbConfig smartDbConfig, SmartDbDataSource smartDbDataSource) {
        Class smartDbImplClass = smartDbConfig.getSupportDatabaseType().getSmartDbNodeImplClass();
        try {
            Constructor constructor = smartDbImplClass.getConstructor(SmartDbDataSource.class, SmartDbConfig.class);
            SmartDbNode dbNode = (SmartDbNode)constructor.newInstance(smartDbDataSource, smartDbConfig);
            return dbNode;
        }
        catch (Throwable e) {
            throw new SmartDbException(e);
        }
    }

    private static SmartDbProxy proxy(SmartDbBuilder builder) {
        if (builder.getRowConverter() == null) {
            builder.setRowConverter(new CaseFormatRowConverter(builder.getColumnNameConverter()));
        } else {
            builder.setRowConverter(builder.getRowConverter());
        }
        DataSource masterDataSource = builder.getMasterDataSource();
        if (masterDataSource == null) {
            masterDataSource = new InnerDataSource(builder);
        }
        SmartDbDataSource master = null;
        SmartDbExtEnum extEnum = builder.getSmartDbExtEnum();
        master = extEnum == null ? new SmartDbDataSourceImpl(masterDataSource) : (extEnum == SmartDbExtEnum.SPRING4 ? new SmartDbDataSource4Spring(masterDataSource) : (extEnum == SmartDbExtEnum.SPRING5 ? new SmartDbDataSource4Spring(masterDataSource) : new SmartDbDataSourceImpl(masterDataSource)));
        SmartDbNode masterNode = SmartDbFactory.buildSmartDbNode(builder, master);
        ArrayList<SmartDbNode> slaves = new ArrayList<SmartDbNode>();
        DataSource[] slaveDataSourceArray = builder.getSlaveDataSource();
        if (slaveDataSourceArray != null) {
            for (DataSource slaveDataSource : slaveDataSourceArray) {
                slaves.add(SmartDbFactory.buildSmartDbNode(builder, new SmartDbDataSourceImpl(slaveDataSource)));
            }
        }
        SmartDbImpl db = new SmartDbImpl();
        db.reload(builder, masterNode, slaves);
        return new SmartDbProxy(db, builder.getFilters());
    }

    private static class InnerDataSource
    implements DataSource {
        private String url;
        private String driverClassName;
        private String username;
        private String password;

        public InnerDataSource(SmartDbBuilder smartDbBuilder) {
            this.url = smartDbBuilder.getUrl();
            this.driverClassName = smartDbBuilder.getDriverClassName();
            this.username = smartDbBuilder.getUsername();
            this.password = smartDbBuilder.getPassword();
        }

        @Override
        public Connection getConnection() throws SQLException {
            try {
                Class.forName(this.driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SmartDbException(e);
            }
            return DriverManager.getConnection(this.url, this.username, this.password);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            try {
                Class.forName(this.driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SmartDbException(e);
            }
            return DriverManager.getConnection(this.url, username, password);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

