/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.lab1024.smartdb.AbstractSmartDbNode;
import net.lab1024.smartdb.SmartDbConfig;
import net.lab1024.smartdb.TransactionSmartDbNode;
import net.lab1024.smartdb.datasource.SmartDbDataSource;
import net.lab1024.smartdb.impl.OracleSmartDbImpl;
import net.lab1024.smartdb.sqlbuilder.ReplaceSqlBuilder;

public class PostgreSqlSmartDbNodeImpl
extends AbstractSmartDbNode {
    public PostgreSqlSmartDbNodeImpl(SmartDbDataSource dataSource, SmartDbConfig smartDbConfig) {
        super(dataSource, smartDbConfig);
    }

    @Override
    public TransactionSmartDbNode getTransaction() {
        return new PostgreSql4Transaction(this.smartDbDataSource, this.smartDbConfig);
    }

    @Override
    public int execute(ReplaceSqlBuilder replaceSqlBuilder) {
        throw new UnsupportedOperationException("oracle cannot support replace operate");
    }

    private class PostgreSql4Transaction
    extends OracleSmartDbImpl
    implements TransactionSmartDbNode {
        private Connection transactionConn;
        private Boolean originalAutoCommit;

        public PostgreSql4Transaction(SmartDbDataSource dataSource, SmartDbConfig smartDbConfig) {
            super(dataSource, smartDbConfig);
        }

        @Override
        public TransactionSmartDbNode getTransaction() {
            return this;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.getTransactionConnection();
        }

        @Override
        public void rollback() throws SQLException {
            this.getTransactionConnection().rollback();
        }

        @Override
        public void begin(int transactionLevel) throws SQLException {
            this.originalAutoCommit = this.getTransactionConnection().getAutoCommit();
            this.transactionConn.setTransactionIsolation(transactionLevel);
            this.transactionConn.setAutoCommit(false);
        }

        @Override
        public void begin() throws SQLException {
            this.getTransactionConnection().setAutoCommit(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getTransactionConnection() throws SQLException {
            if (this.transactionConn == null) {
                PostgreSql4Transaction postgreSql4Transaction = this;
                synchronized (postgreSql4Transaction) {
                    if (this.transactionConn == null) {
                        this.transactionConn = this.smartDbDataSource.getConnection();
                    }
                }
            }
            return this.transactionConn;
        }

        @Override
        public void releaseResources(ResultSet rs, Statement stmt, Connection conn) {
            super.releaseResources(rs, stmt, null);
        }

        @Override
        public void commit() throws SQLException {
            this.getTransactionConnection().commit();
        }

        @Override
        public void releaseConnection() {
            if (this.transactionConn != null) {
                if (this.originalAutoCommit != null) {
                    try {
                        this.transactionConn.setAutoCommit(this.originalAutoCommit);
                    }
                    catch (SQLException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
                this.smartDbDataSource.releaseConnection(this.transactionConn);
                this.transactionConn = null;
            }
        }
    }
}

