/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.handler;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.lab1024.smartdb.mapping.handler.BeanHandler;
import net.lab1024.smartdb.mapping.handler.BeanListHandler;
import net.lab1024.smartdb.mapping.handler.ColumnListHandler;
import net.lab1024.smartdb.mapping.handler.MapHandler;
import net.lab1024.smartdb.mapping.handler.MapListHandler;
import net.lab1024.smartdb.mapping.handler.ResultSetHandler;
import net.lab1024.smartdb.mapping.handler.ScalarHandler;
import net.lab1024.smartdb.mapping.rowconvertor.RowConverter;

public class ResultSetHandlerFactory {
    private RowConverter rowConverter;
    private Map<Class<?>, ResultSetHandler<?>> ListHandlerMap = new ConcurrentHashMap();
    private Map<Class<?>, ResultSetHandler<?>> BeanHandlerMap = new ConcurrentHashMap();

    public ResultSetHandlerFactory(RowConverter rowConverter) {
        this.rowConverter = rowConverter;
        this.ListHandlerMap.put(Integer.TYPE, new ColumnListHandler<Integer>(1, Integer.TYPE));
        this.ListHandlerMap.put(Integer.class, new ColumnListHandler<Integer>(1, Integer.class));
        this.ListHandlerMap.put(Long.TYPE, new ColumnListHandler<Long>(1, Long.TYPE));
        this.ListHandlerMap.put(Long.class, new ColumnListHandler<Long>(1, Long.class));
        this.ListHandlerMap.put(Byte.TYPE, new ColumnListHandler<Byte>(1, Byte.TYPE));
        this.ListHandlerMap.put(Byte.class, new ColumnListHandler<Byte>(1, Byte.class));
        this.ListHandlerMap.put(Short.TYPE, new ColumnListHandler<Short>(1, Short.TYPE));
        this.ListHandlerMap.put(Short.class, new ColumnListHandler<Short>(1, Short.class));
        this.ListHandlerMap.put(Double.TYPE, new ColumnListHandler<Double>(1, Double.TYPE));
        this.ListHandlerMap.put(Double.class, new ColumnListHandler<Double>(1, Double.class));
        this.ListHandlerMap.put(Float.TYPE, new ColumnListHandler<Float>(1, Float.TYPE));
        this.ListHandlerMap.put(Float.class, new ColumnListHandler<Float>(1, Float.class));
        this.ListHandlerMap.put(Boolean.TYPE, new ColumnListHandler<Boolean>(1, Boolean.TYPE));
        this.ListHandlerMap.put(Boolean.class, new ColumnListHandler<Boolean>(1, Boolean.class));
        this.ListHandlerMap.put(Character.TYPE, new ColumnListHandler<Character>(1, Character.TYPE));
        this.ListHandlerMap.put(Character.class, new ColumnListHandler<Character>(1, Character.class));
        this.ListHandlerMap.put(String.class, new ColumnListHandler<String>(1, String.class));
        this.ListHandlerMap.put(BigDecimal.class, new ColumnListHandler<BigDecimal>(1, BigDecimal.class));
        this.ListHandlerMap.put(Map.class, new MapListHandler(rowConverter));
        this.ListHandlerMap.put(HashMap.class, new MapListHandler(rowConverter));
        this.ListHandlerMap.put(Date.class, new ResultSetHandler<List<Date>>(){

            @Override
            public List<Date> handle(ResultSet rs) throws SQLException {
                ArrayList<Date> list = new ArrayList<Date>();
                Timestamp timestamp = rs.getTimestamp(1);
                if (timestamp == null) {
                    list.add(null);
                } else {
                    list.add(new Date(timestamp.getTime()));
                }
                return list;
            }
        });
        this.BeanHandlerMap.put(Integer.TYPE, ScalarHandler.Integer);
        this.BeanHandlerMap.put(Integer.class, ScalarHandler.Integer);
        this.BeanHandlerMap.put(Long.TYPE, ScalarHandler.Long);
        this.BeanHandlerMap.put(Long.class, ScalarHandler.Long);
        this.BeanHandlerMap.put(Byte.TYPE, ScalarHandler.Byte);
        this.BeanHandlerMap.put(Byte.class, ScalarHandler.Byte);
        this.BeanHandlerMap.put(Short.TYPE, ScalarHandler.Short);
        this.BeanHandlerMap.put(Short.class, ScalarHandler.Short);
        this.BeanHandlerMap.put(Double.TYPE, ScalarHandler.Double);
        this.BeanHandlerMap.put(Double.class, ScalarHandler.Double);
        this.BeanHandlerMap.put(Float.TYPE, ScalarHandler.Float);
        this.BeanHandlerMap.put(Float.class, ScalarHandler.Float);
        this.BeanHandlerMap.put(Boolean.TYPE, ScalarHandler.Boolean);
        this.BeanHandlerMap.put(Boolean.class, ScalarHandler.Boolean);
        this.BeanHandlerMap.put(Character.TYPE, ScalarHandler.Char);
        this.BeanHandlerMap.put(Character.class, ScalarHandler.Char);
        this.BeanHandlerMap.put(BigDecimal.class, ScalarHandler.BigDecimal);
        this.BeanHandlerMap.put(String.class, ScalarHandler.String);
        this.BeanHandlerMap.put(Map.class, new MapHandler(rowConverter));
        this.BeanHandlerMap.put(HashMap.class, new MapHandler(rowConverter));
        this.BeanHandlerMap.put(Date.class, new ResultSetHandler<Date>(){

            @Override
            public Date handle(ResultSet rs) throws SQLException {
                Timestamp timestamp = rs.getTimestamp(1);
                if (timestamp == null) {
                    return null;
                }
                return new Date(timestamp.getTime());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ResultSetHandler<T> getObjectResultHandler(Class<T> cls) {
        ResultSetHandler<?> resultSetHandler = this.BeanHandlerMap.get(cls);
        if (resultSetHandler == null) {
            ResultSetHandlerFactory resultSetHandlerFactory = this;
            synchronized (resultSetHandlerFactory) {
                ResultSetHandler<?> againGet = this.BeanHandlerMap.get(cls);
                if (againGet == null) {
                    BeanHandler<T> handler = new BeanHandler<T>(cls, this.rowConverter);
                    this.BeanHandlerMap.put(cls, handler);
                    return handler;
                }
                return againGet;
            }
        }
        return resultSetHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ResultSetHandler<T> getObjectListResultHandler(Class<T> cls) {
        ResultSetHandler<?> resultSetHandler = this.ListHandlerMap.get(cls);
        if (resultSetHandler == null) {
            ResultSetHandlerFactory resultSetHandlerFactory = this;
            synchronized (resultSetHandlerFactory) {
                ResultSetHandler<?> againGet = this.ListHandlerMap.get(cls);
                if (againGet == null) {
                    BeanListHandler<T> handler = new BeanListHandler<T>(cls, this.rowConverter);
                    this.ListHandlerMap.put(cls, handler);
                    return handler;
                }
                return againGet;
            }
        }
        return resultSetHandler;
    }
}

