/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.handler;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import net.lab1024.smartdb.mapping.handler.ResultSetHandler;
import net.lab1024.smartdb.mapping.handler.type.JdbcType;
import net.lab1024.smartdb.mapping.handler.type.TypeHandler;
import net.lab1024.smartdb.mapping.handler.type.TypeHandlerFactory;

public class ScalarHandler<T>
implements ResultSetHandler<T> {
    public static final ScalarHandler<Integer> Integer = new ScalarHandler<Integer>(1, Integer.class);
    public static final ScalarHandler<Long> Long = new ScalarHandler<Long>(1, Long.class);
    public static final ScalarHandler<Byte> Byte = new ScalarHandler<Byte>(1, Byte.class);
    public static final ScalarHandler<Short> Short = new ScalarHandler<Short>(1, Short.class);
    public static final ScalarHandler<Double> Double = new ScalarHandler<Double>(1, Double.class);
    public static final ScalarHandler<Float> Float = new ScalarHandler<Float>(1, Float.class);
    public static final ScalarHandler<Boolean> Boolean = new ScalarHandler<Boolean>(1, Boolean.class);
    public static final ScalarHandler<Character> Char = new ScalarHandler<Character>(1, Character.class);
    public static final ScalarHandler<String> String = new ScalarHandler<String>(1, String.class);
    public static final ScalarHandler<BigDecimal> BigDecimal = new ScalarHandler<BigDecimal>(1, BigDecimal.class);
    public static final ResultSetHandler<Date> Date = new ResultSetHandler<Date>(){

        @Override
        public Date handle(ResultSet rs) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(1);
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }
    };
    private int columnIndex;
    private String columnName;
    private Class<T> cls;

    public ScalarHandler(int columnIndex, Class<T> cls) {
        this.columnIndex = columnIndex;
        this.cls = cls;
        this.columnName = null;
    }

    public ScalarHandler() {
        this(1);
    }

    public ScalarHandler(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public ScalarHandler(String columnName) {
        this(1, columnName);
    }

    private ScalarHandler(int columnIndex, String columnName) {
        this.columnIndex = columnIndex;
        this.columnName = columnName;
    }

    @Override
    public T handle(ResultSet rs) throws SQLException {
        if (rs.next()) {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnType = metaData.getColumnType(this.columnIndex);
            TypeHandler<?> handler = TypeHandlerFactory.getHandler(this.cls);
            JdbcType jdbcType = JdbcType.forCode(columnType);
            if (this.columnName == null) {
                return (T)handler.getResult(rs, this.columnIndex, jdbcType);
            }
            return (T)rs.getObject(this.columnName);
        }
        return null;
    }
}

