/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.handler.type;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.lab1024.smartdb.mapping.handler.type.JdbcType;
import net.lab1024.smartdb.mapping.handler.type.TypeHandler;

public class StringTypeHandler
implements TypeHandler<String> {
    @Override
    public String getResult(ResultSet rs, int columnIndex, JdbcType jdbcType) throws SQLException {
        if (JdbcType.CHAR == jdbcType) {
            return rs.getString(columnIndex);
        }
        if (JdbcType.CLOB == jdbcType) {
            Clob clob = rs.getClob(columnIndex);
            return this.toString(clob);
        }
        if (JdbcType.VARCHAR == jdbcType) {
            return rs.getString(columnIndex);
        }
        if (JdbcType.LONGVARCHAR == jdbcType) {
            return rs.getString(columnIndex);
        }
        if (JdbcType.NVARCHAR == jdbcType) {
            return rs.getNString(columnIndex);
        }
        if (JdbcType.NCHAR == jdbcType) {
            return rs.getNString(columnIndex);
        }
        if (JdbcType.NCLOB == jdbcType) {
            Clob clob = rs.getClob(columnIndex);
            return this.toString(clob);
        }
        return rs.getString(columnIndex);
    }

    @Override
    public String getResult(ResultSet rs, String columnName, JdbcType jdbcType) throws SQLException {
        if (JdbcType.CHAR == jdbcType) {
            return rs.getString(columnName);
        }
        if (JdbcType.CLOB == jdbcType) {
            Clob clob = rs.getClob(columnName);
            return this.toString(clob);
        }
        if (JdbcType.VARCHAR == jdbcType) {
            return rs.getString(columnName);
        }
        if (JdbcType.LONGVARCHAR == jdbcType) {
            return rs.getString(columnName);
        }
        if (JdbcType.NVARCHAR == jdbcType) {
            return rs.getNString(columnName);
        }
        if (JdbcType.NCHAR == jdbcType) {
            return rs.getNString(columnName);
        }
        if (JdbcType.NCLOB == jdbcType) {
            Clob clob = rs.getClob(columnName);
            return this.toString(clob);
        }
        return rs.getString(columnName);
    }

    private String toString(Clob clob) throws SQLException {
        return clob == null ? null : clob.getSubString(1L, (int)clob.length());
    }
}

