/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.rowconvertor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.mapping.rowconvertor.BaseRowConverter;
import net.lab1024.smartdb.mapping.rowconvertor.CaseInsensitiveHashMap;

public class DefaultRowConverter
extends BaseRowConverter {
    public DefaultRowConverter(Map<String, String> columnToPropertyOverrides) {
        super(columnToPropertyOverrides);
    }

    public DefaultRowConverter() {
    }

    @Override
    public <T> T toBean(ResultSet rs, Class<T> type) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        return this.createBean(rs, type, props, columnToProperty, rsmd);
    }

    @Override
    public <T> List<T> toBeanList(ResultSet rs, Class<T> type) throws SQLException {
        if (!rs.next()) {
            return Collections.emptyList();
        }
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        ArrayList<T> results = new ArrayList<T>();
        do {
            results.add(this.createBean(rs, type, props, columnToProperty, rsmd));
        } while (rs.next());
        return results;
    }

    @Override
    public Map<String, Object> toMap(ResultSet rs) throws SQLException {
        CaseInsensitiveHashMap result = new CaseInsensitiveHashMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String columnName = rsmd.getColumnName(i);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(i);
            }
            result.put(columnName, rs.getObject(i));
        }
        return result;
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new SmartDbException("Bean introspection failed: " + e.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String columnName = rsmd.getColumnName(col);
            String propertyName = null;
            if (this.columnToPropertyOverrides.isEmpty()) {
                propertyName = columnName;
            } else {
                propertyName = (String)this.columnToPropertyOverrides.get(columnName);
                if (propertyName == null) {
                    propertyName = columnName;
                }
            }
            for (int i = 0; i < props.length; ++i) {
                if (!propertyName.equalsIgnoreCase(props[i].getName())) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }
}

