/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.pagination;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PaginateResult<T>
implements Serializable {
    private int pageNumber;
    private int pageSize;
    private List<T> records;
    private int startRow;
    private int endRow;
    private long totalRecordCount;
    private int totalPageCount;
    private int firstPageNumber;
    private int prePageNumber;
    private int nextPageNumber;
    private int lastPageNumber;
    private boolean isFirstPage = false;
    private boolean isLastPage = false;
    private boolean hasPreviousPage = false;
    private boolean hasNextPage = false;
    private int navigatePageCount;
    private int[] navigatePageNumbers;

    public PaginateResult(int pageNumber, int pageSize) {
        this(new ArrayList(0), 0L, pageNumber, pageSize);
    }

    public PaginateResult(List<T> list, long totalRecordCount, int pageNumber, int pageSize) {
        this(list, totalRecordCount, pageNumber, pageSize, 8);
    }

    public PaginateResult(List<T> list, long totalRecordCount, int pageNumber, int pageSize, int navigatePageCount) {
        this.records = list == null ? new ArrayList<T>(0) : list;
        this.totalRecordCount = totalRecordCount;
        this.totalPageCount = this.totalRecordCount < 1L ? 0 : (totalRecordCount % (long)pageSize == 0L ? (int)(totalRecordCount / (long)pageSize) : (int)(totalRecordCount / (long)pageSize) + 1);
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.navigatePageCount = navigatePageCount;
        this.calcNavigatepageNums();
        this.calcPage();
        this.judgePageBoudary();
    }

    private void calcNavigatepageNums() {
        if (this.totalPageCount <= this.navigatePageCount) {
            this.navigatePageNumbers = new int[this.totalPageCount];
            for (int i = 0; i < this.totalPageCount; ++i) {
                this.navigatePageNumbers[i] = i + 1;
            }
        } else {
            this.navigatePageNumbers = new int[this.navigatePageCount];
            int startNum = this.pageNumber - this.navigatePageCount / 2;
            int endNum = this.pageNumber + this.navigatePageCount / 2;
            if (startNum < 1) {
                startNum = 1;
                for (int i = 0; i < this.navigatePageCount; ++i) {
                    this.navigatePageNumbers[i] = startNum++;
                }
            } else if (endNum > this.totalPageCount) {
                endNum = this.totalPageCount;
                for (int i = this.navigatePageCount - 1; i >= 0; --i) {
                    this.navigatePageNumbers[i] = endNum--;
                }
            } else {
                for (int i = 0; i < this.navigatePageCount; ++i) {
                    this.navigatePageNumbers[i] = startNum++;
                }
            }
        }
    }

    private void calcPage() {
        if (this.navigatePageNumbers != null && this.navigatePageNumbers.length > 0) {
            this.firstPageNumber = this.navigatePageNumbers[0];
            this.lastPageNumber = this.navigatePageNumbers[this.navigatePageNumbers.length - 1];
            if (this.pageNumber > 1) {
                this.prePageNumber = this.pageNumber - 1;
            }
            if (this.pageNumber < this.totalPageCount) {
                this.nextPageNumber = this.pageNumber + 1;
            }
        }
    }

    private void judgePageBoudary() {
        this.isFirstPage = this.pageNumber == 1;
        this.isLastPage = this.pageNumber == this.totalPageCount;
        this.hasPreviousPage = this.pageNumber > 1;
        this.hasNextPage = this.pageNumber < this.totalPageCount;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public long getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public void setTotalRecordCount(long totalRecordCount) {
        this.totalRecordCount = totalRecordCount;
    }

    public int getTotalPageCount() {
        return this.totalPageCount;
    }

    public void setTotalPageCount(int totalPageCount) {
        this.totalPageCount = totalPageCount;
    }

    public int getFirstPageNumber() {
        return this.firstPageNumber;
    }

    public void setFirstPageNumber(int firstPageNumber) {
        this.firstPageNumber = firstPageNumber;
    }

    public int getPrePageNumber() {
        return this.prePageNumber;
    }

    public void setPrePageNumber(int prePageNumber) {
        this.prePageNumber = prePageNumber;
    }

    public int getNextPageNumber() {
        return this.nextPageNumber;
    }

    public void setNextPageNumber(int nextPageNumber) {
        this.nextPageNumber = nextPageNumber;
    }

    public int getLastPageNumber() {
        return this.lastPageNumber;
    }

    public void setLastPageNumber(int lastPageNumber) {
        this.lastPageNumber = lastPageNumber;
    }

    public boolean isIsFirstPage() {
        return this.isFirstPage;
    }

    public void setIsFirstPage(boolean isFirstPage) {
        this.isFirstPage = isFirstPage;
    }

    public boolean isIsLastPage() {
        return this.isLastPage;
    }

    public void setIsLastPage(boolean isLastPage) {
        this.isLastPage = isLastPage;
    }

    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public int getNavigatePageCount() {
        return this.navigatePageCount;
    }

    public void setNavigatePageCount(int navigatePageCount) {
        this.navigatePageCount = navigatePageCount;
    }

    public int[] getNavigatePageNumbers() {
        return this.navigatePageNumbers;
    }

    public void setNavigatePageNumbers(int[] navigatePageNumbers) {
        this.navigatePageNumbers = navigatePageNumbers;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    public void setFirstPage(boolean firstPage) {
        this.isFirstPage = firstPage;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void setLastPage(boolean lastPage) {
        this.isLastPage = lastPage;
    }

    public String toString() {
        return "PaginateResult{pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", startRow=" + this.startRow + ", endRow=" + this.endRow + ", totalRecordCount=" + this.totalRecordCount + ", totalPageCount=" + this.totalPageCount + ", records=" + this.records + ", firstPageNumber=" + this.firstPageNumber + ", prePageNumber=" + this.prePageNumber + ", nextPageNumber=" + this.nextPageNumber + ", lastPageNumber=" + this.lastPageNumber + ", isFirstPage=" + this.isFirstPage + ", isLastPage=" + this.isLastPage + ", hasPreviousPage=" + this.hasPreviousPage + ", hasNextPage=" + this.hasNextPage + ", navigatePageCount=" + this.navigatePageCount + ", navigatepageNumbers=" + Arrays.toString(this.navigatePageNumbers) + '}';
    }
}

