/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.sqlbuilder.impl;

import java.util.ArrayList;
import java.util.List;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.mapping.reflect.OrmClassFieldMeta;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.sqlbuilder.AbstractSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.DeleteSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.PatternLocationEnum;
import net.lab1024.smartdb.sqlbuilder.SqlBuilderType;

public abstract class AbstractDeleteSqlBuilder
extends AbstractSqlBuilder
implements DeleteSqlBuilder {
    protected String table;
    protected List<Object> whereParamList = null;
    protected StringBuilder whereClause = new StringBuilder();

    public AbstractDeleteSqlBuilder(SmartDbNode smartDbNode) {
        super(smartDbNode);
    }

    @Override
    public SqlBuilderType getSqlBuilderType() {
        return SqlBuilderType.DELETE;
    }

    public String toString() {
        return this.generateSql(false);
    }

    @Override
    public String generateSql() {
        return this.generateSql(false);
    }

    @Override
    public String generateSql(boolean isPretty) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(this.table).append(isPretty ? LINE_SEPARATOR : " ");
        sb.append((CharSequence)this.whereClause);
        sb.append((CharSequence)this.appendSqlBuilder);
        return sb.toString();
    }

    public DeleteSqlBuilder appendSql(String sqlClause) {
        this.appendSqlBuilder.append(" ").append(sqlClause);
        return this;
    }

    @Override
    public DeleteSqlBuilder table(String table) {
        if (table != null) {
            this.table = table;
        }
        return this;
    }

    @Override
    public DeleteSqlBuilder table(Class entityClass) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(entityClass);
        if (classMeta != null) {
            this.table(classMeta.getTableName(this.tableNameConverter));
        }
        return this;
    }

    @Override
    public DeleteSqlBuilder deleteEntity(Object obj) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(obj.getClass());
        this.table(classMeta.getTableName(this.tableNameConverter));
        OrmClassFieldMeta[] primaryKeyFields = classMeta.getPrimaryKeyFields();
        boolean havePrimaryValue = false;
        for (OrmClassFieldMeta primaryKeyField : primaryKeyFields) {
            Object primaryValue = null;
            try {
                primaryValue = primaryKeyField.getField().get(obj);
            }
            catch (IllegalAccessException e) {
                throw new SmartDbException(e);
            }
            if (primaryValue == null) continue;
            String name = primaryKeyField.getOrmColumnName();
            name = this.columnNameConverter.fieldConvertToColumn(name);
            this.whereAnd(String.format("`%s` = ?", name), primaryValue);
            havePrimaryValue = true;
        }
        if (!havePrimaryValue) {
            throw new SmartDbException("Entity's primary keys are null, it will delete all data in database");
        }
        return this;
    }

    @Override
    public DeleteSqlBuilder whereAnd(String where) {
        this.ensureAppendWhereAnd(where);
        return this;
    }

    @Override
    public <T> DeleteSqlBuilder whereAndIn(String column, List<T> inList) {
        if (inList == null || inList.isEmpty()) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(column).append(" in (");
        sb.append("'").append(inList.get(0).toString()).append("'");
        int len = inList.size();
        for (int i = 1; i < len; ++i) {
            sb.append(",'").append(inList.get(i).toString()).append("'");
        }
        sb.append(") ");
        this.ensureAppendWhereAnd(sb.toString());
        return this;
    }

    private void ensureAppendWhereAnd(String where) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append("WHERE ").append(where);
        } else {
            this.whereClause.append(" AND ").append(where);
        }
    }

    private void ensureAppendWhereOr(String where) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append("WHERE ").append(where);
        } else {
            this.whereClause.append(" OR ").append(where);
        }
    }

    private void ensureAddWhereParams(Object ... params) {
        if (params == null || params.length == 0) {
            return;
        }
        if (this.whereParamList == null) {
            this.whereParamList = new ArrayList<Object>();
        }
        for (Object param : params) {
            this.whereParamList.add(param);
        }
    }

    @Override
    public DeleteSqlBuilder whereAnd(String where, Object ... param) {
        this.ensureAppendWhereAnd(where);
        this.ensureAddWhereParams(param);
        return this;
    }

    @Override
    public DeleteSqlBuilder whereAndLikeColumns(String like, String ... columns) {
        if (columns == null || columns.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiColumns(like, true, columns);
        return this;
    }

    @Override
    public DeleteSqlBuilder whereAndLikePatterns(String column, String ... likes) {
        if (likes == null || likes.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiLikes(column, true, likes);
        return this;
    }

    @Override
    public DeleteSqlBuilder whereOr(String where) {
        this.ensureAppendWhereOr(where);
        return this;
    }

    @Override
    public DeleteSqlBuilder whereOr(String where, Object ... param) {
        this.ensureAppendWhereOr(where);
        this.ensureAddWhereParams(param);
        return this;
    }

    @Override
    public DeleteSqlBuilder whereOrLikeColumns(String like, String ... column) {
        if (column == null || column.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiColumns(like, false, column);
        return this;
    }

    @Override
    public DeleteSqlBuilder whereOrLikePatterns(String column, String ... likes) {
        if (likes == null || likes.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiLikes(column, false, likes);
        return this;
    }

    private void appendLikeClause4MultiColumns(String finalLike, boolean isAndThenOr, String ... column) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append(" WHERE ");
        } else {
            this.whereClause.append(isAndThenOr ? " AND " : " OR ");
        }
        int len = column.length - 1;
        if (column.length > 0) {
            this.whereClause.append("( ");
            for (int i = 0; i < column.length; ++i) {
                if (len == i) {
                    this.whereClause.append(column[i]).append(" LIKE '").append(finalLike).append("' ");
                    continue;
                }
                this.whereClause.append(column[i]).append(" LIKE '").append(finalLike).append("' OR ");
            }
            this.whereClause.append(")");
        } else {
            this.whereClause.append(column[0]).append(" LIKE '").append(finalLike).append("' ");
        }
    }

    private void appendLikeClause4MultiLikes(String column, boolean isAndThenOr, String ... finalLikes) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append(" WHERE ");
        } else {
            this.whereClause.append(isAndThenOr ? " AND " : " OR ");
        }
        int len = finalLikes.length - 1;
        if (finalLikes.length > 0) {
            this.whereClause.append("( ");
            for (int i = 0; i < finalLikes.length; ++i) {
                if (len == i) {
                    this.whereClause.append(column).append(" LIKE '").append(finalLikes[i]).append("' ");
                    continue;
                }
                this.whereClause.append(column).append(" LIKE '").append(finalLikes[i]).append("' OR ");
            }
            this.whereClause.append(")");
        } else {
            this.whereClause.append(column).append(" LIKE '").append(finalLikes[0]).append("' ");
        }
    }

    private String percentSignFormat(PatternLocationEnum location, String str) {
        if (location == PatternLocationEnum.AROUND) {
            return String.format("%%%s%%", str);
        }
        if (location == PatternLocationEnum.SUFFIX) {
            return String.format("%s%%", str);
        }
        if (location == PatternLocationEnum.PREFIX) {
            return String.format("%%%s", str);
        }
        throw new RuntimeException("cannot found PatternLocationEnum " + (Object)((Object)location));
    }

    @Override
    public List<Object> getAllParams() {
        return this.whereParamList == null ? new ArrayList(0) : this.whereParamList;
    }

    @Override
    public int execute() {
        return this.smartDbNode.execute(this);
    }
}

