/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.sqlbuilder.impl;

import java.util.ArrayList;
import java.util.List;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.mapping.reflect.OrmClassFieldMeta;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.sqlbuilder.AbstractSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.PatternLocationEnum;
import net.lab1024.smartdb.sqlbuilder.SqlBuilderType;
import net.lab1024.smartdb.sqlbuilder.UpdateSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.convertor.ColumnNameConverter;

public abstract class AbstractUpdateSqlBuilder
extends AbstractSqlBuilder
implements UpdateSqlBuilder {
    protected String table = null;
    protected String asName = null;
    protected List<Object> whereParamList = null;
    protected StringBuilder whereClause = new StringBuilder();
    protected List<String> updateColumns;
    protected List<Object> updateColumnParamList;

    public AbstractUpdateSqlBuilder(SmartDbNode smartDbNode) {
        super(smartDbNode);
    }

    public UpdateSqlBuilder appendSql(String sqlClause) {
        this.appendSqlBuilder.append(" ").append(sqlClause);
        return this;
    }

    @Override
    public SqlBuilderType getSqlBuilderType() {
        return SqlBuilderType.UPDATE;
    }

    @Override
    public UpdateSqlBuilder table(String table) {
        if (table != null) {
            this.table = table;
        }
        return this;
    }

    @Override
    public UpdateSqlBuilder table(Class entityClass) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(entityClass);
        if (classMeta != null) {
            this.table(classMeta.getTableName(this.tableNameConverter));
        }
        return this;
    }

    @Override
    public UpdateSqlBuilder updateColumn(String updateClause) {
        if (this.updateColumns == null) {
            this.updateColumns = new ArrayList<String>();
        }
        this.updateColumns.add(updateClause);
        return this;
    }

    @Override
    public UpdateSqlBuilder updateColumn(String updateClause, Object param) {
        if (this.updateColumns == null) {
            this.updateColumns = new ArrayList<String>();
        }
        this.updateColumns.add(updateClause);
        if (this.updateColumnParamList == null) {
            this.updateColumnParamList = new ArrayList<Object>();
        }
        this.updateColumnParamList.add(param);
        return this;
    }

    public abstract String generateQuestionMarkPart(String var1);

    public abstract String generateSetNullPart(String var1);

    @Override
    public UpdateSqlBuilder updateEntitySelective(Object obj) {
        return this.updateEntitySelective(obj, this.columnNameConverter);
    }

    @Override
    public UpdateSqlBuilder updateEntitySelective(Object obj, ColumnNameConverter columnNameConverter) {
        Class<?> cls = obj.getClass();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(cls);
        this.table(classMeta.getTableName(this.tableNameConverter));
        OrmClassFieldMeta[] columnsFields = classMeta.getColumnsFields();
        try {
            for (OrmClassFieldMeta f : columnsFields) {
                Object o = f.getField().get(obj);
                if (o == null) continue;
                String name = f.getOrmColumnName();
                if (columnNameConverter != null) {
                    name = columnNameConverter.fieldConvertToColumn(name);
                }
                this.updateColumn(this.generateQuestionMarkPart(name), o);
            }
            this.appendPrimaryField(obj, columnNameConverter, classMeta);
        }
        catch (IllegalAccessException e) {
            throw new SmartDbException(e);
        }
        return this;
    }

    @Override
    public UpdateSqlBuilder updateEntity(Object obj) {
        return this.updateEntity(obj, this.columnNameConverter);
    }

    @Override
    public UpdateSqlBuilder updateEntity(Object obj, ColumnNameConverter nameConverter) {
        Class<?> cls = obj.getClass();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(cls);
        this.table(classMeta.getTableName(this.tableNameConverter));
        OrmClassFieldMeta[] columnsFields = classMeta.getColumnsFields();
        try {
            for (OrmClassFieldMeta f : columnsFields) {
                Object o;
                String columnName = f.getOrmColumnName();
                if (nameConverter != null) {
                    columnName = nameConverter.fieldConvertToColumn(columnName);
                }
                if ((o = f.getField().get(obj)) == null) {
                    this.updateColumn(this.generateSetNullPart(columnName));
                    continue;
                }
                this.updateColumn(this.generateQuestionMarkPart(columnName), o);
            }
            this.appendPrimaryField(obj, nameConverter, classMeta);
        }
        catch (IllegalAccessException e) {
            throw new SmartDbException(e);
        }
        return this;
    }

    @Override
    public UpdateSqlBuilder clearWhere() {
        this.whereClause = new StringBuilder();
        this.whereParamList = new ArrayList<Object>();
        return this;
    }

    private void appendPrimaryField(Object obj, ColumnNameConverter nameConverter, OrmClassMeta classMeta) throws IllegalAccessException {
        OrmClassFieldMeta[] primaryFields;
        for (OrmClassFieldMeta f : primaryFields = classMeta.getPrimaryKeyFields()) {
            Object o = f.getField().get(obj);
            if (o == null) continue;
            String name = f.getOrmColumnName();
            if (nameConverter != null) {
                name = nameConverter.fieldConvertToColumn(name);
            }
            this.whereAnd(this.generateQuestionMarkPart(name), o);
        }
    }

    @Override
    public UpdateSqlBuilder whereAnd(String where) {
        this.ensureAppendWhereAnd(where);
        return this;
    }

    private void ensureAppendWhereAnd(String where) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append("WHERE ").append(where);
        } else {
            this.whereClause.append(" AND ").append(where);
        }
    }

    private void ensureAppendWhereOr(String where) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append("WHERE ").append(where);
        } else {
            this.whereClause.append(" OR ").append(where);
        }
    }

    private void ensureAddWhereParams(Object ... params) {
        if (params == null || params.length == 0) {
            return;
        }
        if (this.whereParamList == null) {
            this.whereParamList = new ArrayList<Object>();
        }
        for (Object param : params) {
            this.whereParamList.add(param);
        }
    }

    @Override
    public UpdateSqlBuilder whereAnd(String where, Object ... param) {
        this.ensureAppendWhereAnd(where);
        this.ensureAddWhereParams(param);
        return this;
    }

    @Override
    public UpdateSqlBuilder whereAndLikeForMultiColumn(String like, String ... column) {
        if (column == null || column.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiColumns(like, true, column);
        return this;
    }

    @Override
    public UpdateSqlBuilder whereAndLikeForMultiPattern(String column, String ... likes) {
        if (likes == null || likes.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiLikes(column, true, likes);
        return this;
    }

    @Override
    public UpdateSqlBuilder whereAndLikeForMultiColumn(String like, PatternLocationEnum location, String ... column) {
        if (column == null || column.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiColumns(this.percentSignFormat(location, like), true, column);
        return this;
    }

    @Override
    public UpdateSqlBuilder whereAndLikeForMultiPattern(String column, PatternLocationEnum location, String ... likes) {
        if (likes == null || likes.length < 1) {
            return this;
        }
        String[] finalLikeArr = new String[likes.length];
        for (int i = 0; i < likes.length; ++i) {
            finalLikeArr[i] = this.percentSignFormat(location, likes[i]);
        }
        this.appendLikeClause4MultiLikes(column, true, finalLikeArr);
        return this;
    }

    @Override
    public UpdateSqlBuilder whereOr(String where) {
        this.ensureAppendWhereOr(where);
        return this;
    }

    @Override
    public UpdateSqlBuilder whereOr(String where, Object ... param) {
        this.ensureAppendWhereOr(where);
        this.ensureAddWhereParams(param);
        return this;
    }

    @Override
    public UpdateSqlBuilder whereOrLikeForMultiColumn(String like, String ... column) {
        if (column == null || column.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiColumns(like, false, column);
        return this;
    }

    private void appendLikeClause4MultiColumns(String finalLike, boolean isAndThenOr, String ... column) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append(" WHERE ");
        } else {
            this.whereClause.append(isAndThenOr ? " AND " : " OR ");
        }
        int len = column.length - 1;
        if (column.length > 0) {
            this.whereClause.append("( ");
            for (int i = 0; i < column.length; ++i) {
                if (len == i) {
                    this.whereClause.append(column[i]).append(" LIKE '").append(finalLike).append("' ");
                    continue;
                }
                this.whereClause.append(column[i]).append(" LIKE '").append(finalLike).append("' OR ");
            }
            this.whereClause.append(")");
        } else {
            this.whereClause.append(column[0]).append(" LIKE '").append(finalLike).append("' ");
        }
    }

    private void appendLikeClause4MultiLikes(String column, boolean isAndThenOr, String ... finalLikes) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append(" WHERE ");
        } else {
            this.whereClause.append(isAndThenOr ? " AND " : " OR ");
        }
        int len = finalLikes.length - 1;
        if (finalLikes.length > 0) {
            this.whereClause.append("( ");
            for (int i = 0; i < finalLikes.length; ++i) {
                if (len == i) {
                    this.whereClause.append(column).append(" LIKE '").append(finalLikes[i]).append("' ");
                    continue;
                }
                this.whereClause.append(column).append(" LIKE '").append(finalLikes[i]).append("' OR ");
            }
            this.whereClause.append(")");
        } else {
            this.whereClause.append(column).append(" LIKE '").append(finalLikes[0]).append("' ");
        }
    }

    @Override
    public UpdateSqlBuilder whereOrLikeForMultiPattern(String column, String ... likes) {
        if (likes == null || likes.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiLikes(column, false, likes);
        return this;
    }

    @Override
    public UpdateSqlBuilder whereOrLikeForMultiColumn(String like, PatternLocationEnum location, String ... column) {
        if (column == null || column.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiColumns(this.percentSignFormat(location, like), false, column);
        return this;
    }

    private String percentSignFormat(PatternLocationEnum location, String str) {
        if (location == PatternLocationEnum.AROUND) {
            return String.format("%%%s%%", str);
        }
        if (location == PatternLocationEnum.SUFFIX) {
            return String.format("%s%%", str);
        }
        if (location == PatternLocationEnum.PREFIX) {
            return String.format("%%%s", str);
        }
        throw new RuntimeException("cannot found PatternLocationEnum " + (Object)((Object)location));
    }

    @Override
    public UpdateSqlBuilder whereOrLikeForMultiPattern(String column, PatternLocationEnum location, String ... likes) {
        if (likes == null || likes.length < 1) {
            return this;
        }
        String[] finalLikeArr = new String[likes.length];
        for (int i = 0; i < likes.length; ++i) {
            finalLikeArr[i] = this.percentSignFormat(location, likes[i]);
        }
        this.appendLikeClause4MultiLikes(column, false, finalLikeArr);
        return this;
    }

    @Override
    public String generateSql() {
        return this.generateSql(false);
    }

    @Override
    public String generateSql(boolean isPretty) {
        StringBuilder updateStringBuilder = new StringBuilder();
        updateStringBuilder.append("UPDATE ").append(this.table).append(isPretty ? LINE_SEPARATOR : " ");
        if (this.updateColumns != null && this.updateColumns.size() > 0) {
            updateStringBuilder.append("SET ");
            int len = this.updateColumns.size() - 1;
            for (int i = 0; i < this.updateColumns.size(); ++i) {
                if (i == len) {
                    updateStringBuilder.append(" ").append(this.updateColumns.get(i));
                    continue;
                }
                updateStringBuilder.append(" ").append(this.updateColumns.get(i)).append(",");
            }
            updateStringBuilder.append(isPretty ? LINE_SEPARATOR : " ");
        }
        updateStringBuilder.append((CharSequence)this.whereClause);
        updateStringBuilder.append((CharSequence)this.appendSqlBuilder);
        return updateStringBuilder.toString();
    }

    public String toString() {
        return this.generateSql(false);
    }

    @Override
    public List<Object> getWhereParamList() {
        return this.whereParamList;
    }

    @Override
    public List<Object> getUpdateParams() {
        return this.updateColumnParamList;
    }

    @Override
    public List<Object> getAllParams() {
        int count = this.updateColumnParamList == null ? 0 : this.updateColumnParamList.size() + (this.whereParamList == null ? 0 : this.whereParamList.size());
        ArrayList<Object> list = new ArrayList<Object>(count);
        if (this.updateColumnParamList != null) {
            list.addAll(this.updateColumnParamList);
        }
        if (this.whereParamList != null) {
            list.addAll(this.whereParamList);
        }
        return list;
    }

    @Override
    public int execute() {
        return this.smartDbNode.execute(this);
    }
}

