/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.FilterContext;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;

public abstract class PluginMonitoringFilter
extends MonitoringFilter {
    private final SessionListener emulatedSessionListener = new SessionListener(true);

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        FilterContext filterContext = this.getFilterContext();
        if (filterContext != null) {
            TimerTask sessionTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        PluginMonitoringFilter.this.unregisterInvalidatedSessions();
                    }
                    catch (Throwable t) {
                        LOG.warn("exception while checking sessions", t);
                    }
                }
            };
            int resolutionSeconds = Parameters.getResolutionSeconds();
            int periodMillis = resolutionSeconds * 1000;
            Timer timer = filterContext.getTimer();
            timer.schedule(sessionTimerTask, periodMillis - 5000, (long)periodMillis);
        }
    }

    @Override
    public void destroy() {
        this.emulatedSessionListener.removeAllActivationListeners();
        super.destroy();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            super.doFilter(request, response, chain);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        this.registerSessionIfNeeded(httpRequest);
        super.doFilter(request, response, chain);
        this.unregisterSessionIfNeeded(httpRequest);
    }

    private void registerSessionIfNeeded(HttpServletRequest httpRequest) {
        if (httpRequest.isRequestedSessionIdValid()) {
            HttpSession session = httpRequest.getSession(false);
            this.emulatedSessionListener.registerSessionIfNeeded(session);
        }
    }

    private void unregisterSessionIfNeeded(HttpServletRequest httpRequest) {
        HttpSession session = httpRequest.getSession(false);
        this.emulatedSessionListener.unregisterSessionIfNeeded(session);
    }

    void unregisterInvalidatedSessions() {
        this.emulatedSessionListener.unregisterInvalidatedSessions();
    }

    public static void logForDebug(String msg) {
        LOG.debug(msg);
    }
}

