/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.internal.model.CloudWatch;
import net.bull.javamelody.internal.model.Graphite;
import net.bull.javamelody.internal.model.JavaInformations;

abstract class MetricsPublisher {
    MetricsPublisher() {
    }

    static List<MetricsPublisher> getMetricsPublishers(List<JavaInformations> javaInformationsList) {
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        ArrayList<MetricsPublisher> metricsPublishers = new ArrayList<MetricsPublisher>();
        StringBuilder sb = new StringBuilder();
        for (JavaInformations javaInformations : javaInformationsList) {
            if (sb.length() != 0) {
                sb.append('_');
            }
            sb.append(javaInformations.getHost().replaceFirst("@.*", ""));
        }
        String contextPath = javaInformationsList.get(0).getContextPath();
        String hosts = sb.toString();
        Graphite graphite = Graphite.getInstance(contextPath, hosts);
        CloudWatch cloudWatch = CloudWatch.getInstance(contextPath, hosts);
        if (graphite != null) {
            metricsPublishers.add(graphite);
        }
        if (cloudWatch != null) {
            metricsPublishers.add(cloudWatch);
        }
        if (metricsPublishers.isEmpty()) {
            return Collections.emptyList();
        }
        return metricsPublishers;
    }

    abstract void addValue(String var1, double var2) throws IOException;

    abstract void send() throws IOException;

    abstract void stop();
}

