/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.util.Locale;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Range;

public enum Period {
    JOUR(1, "calendar_view_day.png", "day"),
    SEMAINE(7, "calendar_view_week.png", "week"),
    MOIS(31, "calendar_view_month.png", "month"),
    ANNEE(366, "calendar.png", "year"),
    TOUT(732, "calendar.png", "all");

    private final String code;
    private final String mailCode;
    private final int durationDays;
    private final int durationSeconds;
    private final String iconName;
    private final Range range;

    private Period(int durationDays, String iconName, String mailCode) {
        this.durationDays = durationDays;
        this.durationSeconds = durationDays * 24 * 60 * 60;
        this.iconName = iconName;
        this.mailCode = mailCode;
        this.code = this.toString().toLowerCase(Locale.ENGLISH);
        this.range = Range.createPeriodRange(this);
    }

    public static Period valueOfIgnoreCase(String period) {
        return Period.valueOf(period.toUpperCase(Locale.ENGLISH).trim());
    }

    public static Period valueOfByMailCode(String mailPeriod) {
        String mailCode = mailPeriod.toLowerCase(Locale.ENGLISH).trim();
        for (Period period : Period.values()) {
            if (!period.mailCode.equals(mailCode)) continue;
            return period;
        }
        throw new IllegalArgumentException(mailPeriod);
    }

    public String getCode() {
        return this.code;
    }

    public String getMailCode() {
        return this.mailCode;
    }

    public String getLabel() {
        return I18N.getString(this.code + "_label");
    }

    public String getLinkLabel() {
        return I18N.getString(this.code + "_link_label");
    }

    int getDurationDays() {
        return this.durationDays;
    }

    int getDurationSeconds() {
        return this.durationSeconds;
    }

    public String getIconName() {
        return this.iconName;
    }

    public Range getRange() {
        return this.range;
    }
}

