/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.auxiliary;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public class MethodCallProxy
implements AuxiliaryType {
    private static final String FIELD_NAME_PREFIX = "argument";
    private final Implementation.SpecialMethodInvocation specialMethodInvocation;
    private final boolean serializableProxy;
    private final Assigner assigner;

    public MethodCallProxy(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializableProxy) {
        this(specialMethodInvocation, serializableProxy, Assigner.DEFAULT);
    }

    public MethodCallProxy(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializableProxy, Assigner assigner) {
        this.specialMethodInvocation = specialMethodInvocation;
        this.serializableProxy = serializableProxy;
        this.assigner = assigner;
    }

    private static LinkedHashMap<String, TypeDescription> extractFields(MethodDescription methodDescription) {
        LinkedHashMap<String, TypeDescription> typeDescriptions = new LinkedHashMap<String, TypeDescription>();
        int currentIndex = 0;
        if (!methodDescription.isStatic()) {
            typeDescriptions.put(MethodCallProxy.fieldName(currentIndex++), methodDescription.getDeclaringType().asErasure());
        }
        for (ParameterDescription parameterDescription : methodDescription.getParameters()) {
            typeDescriptions.put(MethodCallProxy.fieldName(currentIndex++), parameterDescription.getType().asErasure());
        }
        return typeDescriptions;
    }

    private static String fieldName(int index) {
        return String.format("%s%d", FIELD_NAME_PREFIX, index);
    }

    @Override
    public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
        Type[] typeArray;
        MethodDescription.InDefinedShape accessorMethod = methodAccessorFactory.registerAccessorFor(this.specialMethodInvocation);
        LinkedHashMap<String, TypeDescription> parameterFields = MethodCallProxy.extractFields(accessorMethod);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition receiverTypeDefinition = new ByteBuddy(classFileVersion).with(PrecomputedMethodGraph.INSTANCE).subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER).implement(new Type[]{Runnable.class, Callable.class}).intercept(new MethodCall(accessorMethod, this.assigner));
        if (this.serializableProxy) {
            Class[] classArray = new Class[1];
            typeArray = classArray;
            classArray[0] = Serializable.class;
        } else {
            typeArray = new Class[]{};
        }
        DynamicType.Builder<Object> builder = receiverTypeDefinition.implement(typeArray).defineConstructor(new ModifierContributor.ForMethod[0]).withParameters(parameterFields.values()).intercept(ConstructorCall.INSTANCE);
        for (Map.Entry<String, TypeDescription> field : parameterFields.entrySet()) {
            builder = builder.defineField(field.getKey(), (TypeDefinition)field.getValue(), Visibility.PRIVATE);
        }
        return builder.make();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodCallProxy that = (MethodCallProxy)other;
        return this.serializableProxy == that.serializableProxy && this.assigner.equals(that.assigner) && this.specialMethodInvocation.equals(that.specialMethodInvocation);
    }

    public int hashCode() {
        int result = this.specialMethodInvocation.hashCode();
        result = 31 * result + (this.serializableProxy ? 1 : 0);
        result = 31 * result + this.assigner.hashCode();
        return result;
    }

    public String toString() {
        return "MethodCallProxy{specialMethodInvocation=" + this.specialMethodInvocation + ", serializableProxy=" + this.serializableProxy + ", assigner=" + this.assigner + '}';
    }

    public static class AssignableSignatureCall
    implements StackManipulation {
        private final Implementation.SpecialMethodInvocation specialMethodInvocation;
        private final boolean serializable;

        public AssignableSignatureCall(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean serializable) {
            this.specialMethodInvocation = specialMethodInvocation;
            this.serializable = serializable;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            TypeDescription auxiliaryType = implementationContext.register(new MethodCallProxy(this.specialMethodInvocation, this.serializable));
            return new StackManipulation.Compound(TypeCreation.of(auxiliaryType), Duplication.SINGLE, MethodVariableAccess.allArgumentsOf(this.specialMethodInvocation.getMethodDescription()).prependThisReference(), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)auxiliaryType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly())).apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.serializable == ((AssignableSignatureCall)other).serializable && this.specialMethodInvocation.equals(((AssignableSignatureCall)other).specialMethodInvocation);
        }

        public int hashCode() {
            return 31 * this.specialMethodInvocation.hashCode() + (this.serializable ? 1 : 0);
        }

        public String toString() {
            return "MethodCallProxy.AssignableSignatureCall{specialMethodInvocation=" + this.specialMethodInvocation + ", serializableProxy=" + this.serializable + '}';
        }
    }

    protected static class MethodCall
    implements Implementation {
        private final MethodDescription accessorMethod;
        private final Assigner assigner;

        protected MethodCall(MethodDescription accessorMethod, Assigner assigner) {
            this.accessorMethod = accessorMethod;
            this.assigner = assigner;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.accessorMethod.equals(((MethodCall)other).accessorMethod) && this.assigner.equals(((MethodCall)other).assigner);
        }

        public int hashCode() {
            return this.accessorMethod.hashCode() + 31 * this.assigner.hashCode();
        }

        public String toString() {
            return "MethodCallProxy.MethodCall{accessorMethod=" + this.accessorMethod + ", assigner=" + this.assigner + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                StackManipulation thisReference = MethodVariableAccess.of(this.instrumentedType).loadOffset(0);
                FieldList<FieldDescription.InDefinedShape> fieldList = this.instrumentedType.getDeclaredFields();
                StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                int index = 0;
                for (FieldDescription fieldDescription : fieldList) {
                    fieldLoading[index++] = new StackManipulation.Compound(thisReference, FieldAccess.forField(fieldDescription).getter());
                }
                StackManipulation.Size stackSize = new StackManipulation.Compound(new StackManipulation.Compound(fieldLoading), MethodInvocation.invoke(MethodCall.this.accessorMethod), MethodCall.this.assigner.assign(MethodCall.this.accessorMethod.getReturnType(), instrumentedMethod.getReturnType(), Assigner.Typing.DYNAMIC), MethodReturn.returning(instrumentedMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private MethodCall getMethodCall() {
                return MethodCall.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && MethodCall.this.equals(((Appender)other).getMethodCall());
            }

            public int hashCode() {
                return 31 * MethodCall.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "MethodCallProxy.MethodCall.Appender{methodCall=" + MethodCall.this + ", instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static enum ConstructorCall implements Implementation
    {
        INSTANCE;

        private final MethodDescription objectTypeDefaultConstructor = (MethodDescription)((MethodList)TypeDescription.OBJECT.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        public String toString() {
            return "MethodCallProxy.ConstructorCall." + this.name();
        }

        protected static class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                StackManipulation thisReference = MethodVariableAccess.REFERENCE.loadOffset(0);
                FieldList<FieldDescription.InDefinedShape> fieldList = this.instrumentedType.getDeclaredFields();
                StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                int index = 0;
                for (FieldDescription fieldDescription : fieldList) {
                    fieldLoading[index] = new StackManipulation.Compound(thisReference, MethodVariableAccess.of(fieldDescription.getType().asErasure()).loadOffset(((ParameterDescription)instrumentedMethod.getParameters().get(index)).getOffset()), FieldAccess.forField(fieldDescription).putter());
                    ++index;
                }
                StackManipulation.Size stackSize = new StackManipulation.Compound(thisReference, MethodInvocation.invoke(INSTANCE.objectTypeDefaultConstructor), new StackManipulation.Compound(fieldLoading), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "MethodCallProxy.ConstructorCall.Appender{instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static enum PrecomputedMethodGraph implements MethodGraph.Compiler
    {
        INSTANCE;

        private final MethodGraph.Linked methodGraph;

        @SuppressFBWarnings(value={"SE_BAD_FIELD_STORE"}, justification="Precomputed method graph is not intended for serialization")
        private PrecomputedMethodGraph() {
            LinkedHashMap<MethodDescription.SignatureToken, MethodGraph.Node> nodes = new LinkedHashMap<MethodDescription.SignatureToken, MethodGraph.Node>();
            MethodDescription.Latent callMethod = new MethodDescription.Latent(new TypeDescription.ForLoadedType(Callable.class), "call", 1025, Collections.emptyList(), TypeDescription.Generic.OBJECT, Collections.emptyList(), Collections.singletonList(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Exception.class)), Collections.emptyList(), AnnotationValue.UNDEFINED, TypeDescription.Generic.UNDEFINED);
            nodes.put(callMethod.asSignatureToken(), new MethodGraph.Node.Simple(callMethod));
            MethodDescription.Latent runMethod = new MethodDescription.Latent(new TypeDescription.ForLoadedType(Runnable.class), "run", 1025, Collections.emptyList(), TypeDescription.Generic.VOID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), AnnotationValue.UNDEFINED, TypeDescription.Generic.UNDEFINED);
            nodes.put(runMethod.asSignatureToken(), new MethodGraph.Node.Simple(runMethod));
            MethodGraph.Simple methodGraph = new MethodGraph.Simple(nodes);
            this.methodGraph = new MethodGraph.Linked.Delegation(methodGraph, methodGraph, Collections.<TypeDescription, MethodGraph>emptyMap());
        }

        @Override
        public MethodGraph.Linked compile(TypeDescription typeDescription) {
            return this.compile(typeDescription, typeDescription);
        }

        @Override
        public MethodGraph.Linked compile(TypeDefinition typeDefinition, TypeDescription viewPoint) {
            return this.methodGraph;
        }

        public String toString() {
            return "MethodCallProxy.PrecomputedMethodGraph." + this.name();
        }
    }
}

