/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.check;

import com.google.common.collect.ImmutableSet;
import io.grpc.Grpc;
import io.grpc.ServerCall;
import io.grpc.inprocess.InProcessSocketAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.devh.boot.grpc.server.security.check.AccessPredicates;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public interface AccessPredicate
extends BiPredicate<Authentication, ServerCall<?, ?>> {
    @Override
    public boolean test(Authentication var1, ServerCall<?, ?> var2);

    default public AccessPredicate negate() {
        return (a, c) -> !this.test(a, c);
    }

    default public AccessPredicate and(Predicate<? super Authentication> other) {
        Objects.requireNonNull(other);
        return (a, c) -> this.test(a, c) && other.test(a);
    }

    default public AccessPredicate and(BiPredicate<? super Authentication, ? super ServerCall<?, ?>> other) {
        Objects.requireNonNull(other);
        return (a, c) -> this.test(a, c) && other.test((Authentication)a, (ServerCall<?, ?>)c);
    }

    default public AccessPredicate or(Predicate<? super Authentication> other) {
        Objects.requireNonNull(other);
        return (a, c) -> this.test(a, c) || other.test(a);
    }

    default public AccessPredicate or(BiPredicate<? super Authentication, ? super ServerCall<?, ?>> other) {
        Objects.requireNonNull(other);
        return (a, c) -> this.test(a, c) || other.test((Authentication)a, (ServerCall<?, ?>)c);
    }

    public static AccessPredicate permitAll() {
        return AccessPredicates.PERMIT_ALL;
    }

    public static AccessPredicate authenticated() {
        return (a, c) -> true;
    }

    public static AccessPredicate fullyAuthenticated() {
        return (a, c) -> !(a instanceof AnonymousAuthenticationToken);
    }

    public static AccessPredicate denyAll() {
        return (a, c) -> false;
    }

    public static AccessPredicate hasRole(String role) {
        Objects.requireNonNull(role, "role");
        return (a, c) -> {
            for (GrantedAuthority authority : a.getAuthorities()) {
                if (!role.equals(authority.getAuthority())) continue;
                return true;
            }
            return false;
        };
    }

    public static AccessPredicate hasAuthority(GrantedAuthority role) {
        Objects.requireNonNull(role, "role");
        return (a, c) -> {
            for (GrantedAuthority authority : a.getAuthorities()) {
                if (!role.equals(authority)) continue;
                return true;
            }
            return false;
        };
    }

    public static AccessPredicate hasAnyRole(String ... roles) {
        Objects.requireNonNull(roles, "roles");
        return AccessPredicate.hasAnyRole(Arrays.asList(roles));
    }

    public static AccessPredicate hasAnyRole(Collection<String> roles) {
        Objects.requireNonNull(roles, "roles");
        roles.forEach(role -> Objects.requireNonNull(role, "role"));
        ImmutableSet immutableRoles = ImmutableSet.copyOf(roles);
        return (arg_0, arg_1) -> AccessPredicate.lambda$hasAnyRole$11((Set)immutableRoles, arg_0, arg_1);
    }

    public static AccessPredicate hasAnyAuthority(GrantedAuthority ... roles) {
        Objects.requireNonNull(roles, "roles");
        return AccessPredicate.hasAnyAuthority(Arrays.asList(roles));
    }

    public static AccessPredicate hasAnyAuthority(Collection<GrantedAuthority> roles) {
        Objects.requireNonNull(roles, "roles");
        roles.forEach(role -> Objects.requireNonNull(role, "role"));
        ImmutableSet immutableRoles = ImmutableSet.copyOf(roles);
        return (arg_0, arg_1) -> AccessPredicate.lambda$hasAnyAuthority$13((Set)immutableRoles, arg_0, arg_1);
    }

    public static AccessPredicate hasAllRoles(String ... roles) {
        Objects.requireNonNull(roles, "roles");
        return AccessPredicate.hasAnyRole(Arrays.asList(roles));
    }

    public static AccessPredicate hasAllRoles(Collection<String> roles) {
        Objects.requireNonNull(roles, "roles");
        roles.forEach(role -> Objects.requireNonNull(role, "role"));
        ImmutableSet immutableRoles = ImmutableSet.copyOf(roles);
        return (arg_0, arg_1) -> AccessPredicate.lambda$hasAllRoles$15((Set)immutableRoles, arg_0, arg_1);
    }

    public static AccessPredicate hasAllAuthorities(GrantedAuthority ... roles) {
        Objects.requireNonNull(roles, "roles");
        return AccessPredicate.hasAllAuthorities(Arrays.asList(roles));
    }

    public static AccessPredicate hasAllAuthorities(Collection<GrantedAuthority> roles) {
        Objects.requireNonNull(roles, "roles");
        roles.forEach(role -> Objects.requireNonNull(role, "role"));
        ImmutableSet immutableRoles = ImmutableSet.copyOf(roles);
        return (arg_0, arg_1) -> AccessPredicate.lambda$hasAllAuthorities$17((Set)immutableRoles, arg_0, arg_1);
    }

    public static AccessPredicate fromClientAddress(Predicate<? super SocketAddress> remoteAddressCheck) {
        Objects.requireNonNull(remoteAddressCheck, "remoteAddressCheck");
        return (a, c) -> remoteAddressCheck.test((SocketAddress)c.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
    }

    public static AccessPredicate toServerAddress(Predicate<? super SocketAddress> localAddressCheck) {
        Objects.requireNonNull(localAddressCheck, "localAddressCheck");
        return (a, c) -> localAddressCheck.test((SocketAddress)c.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR));
    }

    private static /* synthetic */ boolean lambda$hasAllAuthorities$17(Set immutableRoles, Authentication a, ServerCall c) {
        for (GrantedAuthority authority : a.getAuthorities()) {
            if (immutableRoles.contains(authority)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$hasAllRoles$15(Set immutableRoles, Authentication a, ServerCall c) {
        for (GrantedAuthority authority : a.getAuthorities()) {
            if (immutableRoles.contains(authority.getAuthority())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$hasAnyAuthority$13(Set immutableRoles, Authentication a, ServerCall c) {
        for (GrantedAuthority authority : a.getAuthorities()) {
            if (!immutableRoles.contains(authority)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$hasAnyRole$11(Set immutableRoles, Authentication a, ServerCall c) {
        for (GrantedAuthority authority : a.getAuthorities()) {
            if (!immutableRoles.contains(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public static interface SocketPredicate
    extends Predicate<SocketAddress> {
        public static SocketPredicate type(Class<? extends SocketAddress> type) {
            Objects.requireNonNull(type, "type");
            return type::isInstance;
        }

        public static <T> SocketPredicate typeAnd(Class<T> type, Predicate<T> condition) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(condition, "condition");
            return s -> type.isInstance(s) && condition.test(s);
        }

        public static SocketPredicate inProcess() {
            return SocketPredicate.type(InProcessSocketAddress.class);
        }

        public static SocketPredicate inProcess(String name) {
            Objects.requireNonNull(name, "name");
            return SocketPredicate.typeAnd(InProcessSocketAddress.class, s -> name.equals(s.getName()));
        }

        public static SocketPredicate inet() {
            return SocketPredicate.type(InetSocketAddress.class);
        }
    }
}

